/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.ProtonSession;
import com.azure.core.amqp.implementation.ProtonSessionWrapper;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.ReactorSession;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.engine.Connection;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

final class ReactorSessionCache {
    private final ConcurrentMap<String, Entry> entries = new ConcurrentHashMap<String, Entry>();
    private final String fullyQualifiedNamespace;
    private final String connectionId;
    private final ReactorHandlerProvider handlerProvider;
    private final ReactorProvider reactorProvider;
    private final Duration openTimeout;
    private final AtomicBoolean isOwnerDisposed;
    private final ClientLogger logger;

    ReactorSessionCache(String connectionId, String fullyQualifiedNamespace, ReactorHandlerProvider handlerProvider, ReactorProvider reactorProvider, Duration openTimeout, ClientLogger logger) {
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.connectionId = connectionId;
        this.handlerProvider = handlerProvider;
        this.reactorProvider = reactorProvider;
        this.openTimeout = openTimeout;
        this.isOwnerDisposed = new AtomicBoolean(false);
        this.logger = logger;
    }

    Mono<ReactorSession> getOrLoad(Mono<Connection> connectionMono, String name, Loader loader) {
        Mono entryMono = connectionMono.map(connection -> this.entries.computeIfAbsent(name, sessionName -> {
            ReactorSession session = this.load((Connection)connection, (String)sessionName, loader);
            Disposable disposable = this.setupAutoEviction(session);
            return new Entry(session, disposable);
        }));
        return entryMono.flatMap(entry -> {
            ReactorSession session = ((Entry)entry).getSession();
            return session.open().doOnError(error -> this.evict(session, "Evicting failed to open or in-active session.", (Throwable)error));
        });
    }

    boolean evict(String name) {
        if (name == null) {
            return false;
        }
        Entry removed = (Entry)this.entries.remove(name);
        if (removed != null) {
            removed.dispose();
        }
        return removed != null;
    }

    void setOwnerDisposed() {
        this.isOwnerDisposed.set(true);
    }

    Mono<Void> awaitClose() {
        ArrayList<Mono> closing = new ArrayList<Mono>(this.entries.size());
        for (Entry entry : this.entries.values()) {
            closing.add(entry.awaitSessionClose());
        }
        return Mono.when(closing);
    }

    private ReactorSession load(Connection connection, String name, Loader loader) {
        ProtonSession protonSession = new ProtonSession(this.connectionId, this.fullyQualifiedNamespace, connection, this.handlerProvider, this.reactorProvider, name, this.openTimeout, this.logger);
        return loader.load(new ProtonSessionWrapper(protonSession));
    }

    private Disposable setupAutoEviction(ReactorSession session) {
        return session.getEndpointStates().subscribe(__ -> {}, error -> this.evict(session, "Evicting session terminated with error.", (Throwable)error), () -> this.evict(session, "Evicting terminated session.", null));
    }

    private void evict(ReactorSession session, String message, Throwable error) {
        if (this.isOwnerDisposed.get()) {
            return;
        }
        String name = session.getSessionName();
        String id = session.getId();
        if (error != null) {
            this.logger.atInfo().addKeyValue("sessionName", name).addKeyValue("sessionId", id).log(message, new Object[]{error});
        } else {
            this.logger.atInfo().addKeyValue("sessionName", name).addKeyValue("sessionId", id).log(message);
        }
        this.evict(name);
    }

    @FunctionalInterface
    static interface Loader {
        public ReactorSession load(ProtonSessionWrapper var1);
    }

    private static final class Entry
    extends AtomicBoolean {
        private final ReactorSession session;
        private final Disposable disposable;

        private Entry(ReactorSession session, Disposable disposable) {
            super(false);
            this.session = session;
            this.disposable = disposable;
        }

        private ReactorSession getSession() {
            return this.session;
        }

        private Mono<Void> awaitSessionClose() {
            return this.session.isClosed();
        }

        private void dispose() {
            if (super.getAndSet(true)) {
                return;
            }
            this.session.closeAsync("closing session.", null, true).subscribe();
            this.disposable.dispose();
        }
    }
}

