/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.handler.DispatchHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;

public final class ReactorDispatcher {
    private final ClientLogger logger = new ClientLogger(ReactorDispatcher.class);
    private final CloseHandler onClose;
    private final Reactor reactor;
    private final Pipe ioSignal;
    private final ConcurrentLinkedQueue<Work> workQueue;
    private final WorkScheduler workScheduler;

    public ReactorDispatcher(Reactor reactor) throws IOException {
        this.reactor = reactor;
        this.ioSignal = Pipe.open();
        this.workQueue = new ConcurrentLinkedQueue();
        this.onClose = new CloseHandler();
        this.workScheduler = new WorkScheduler();
        this.initializeSelectable();
    }

    private void initializeSelectable() {
        Selectable schedulerSelectable = this.reactor.selectable();
        schedulerSelectable.setChannel((SelectableChannel)this.ioSignal.source());
        schedulerSelectable.onReadable((Selectable.Callback)this.workScheduler);
        schedulerSelectable.onFree((Selectable.Callback)this.onClose);
        schedulerSelectable.setReading(true);
        this.reactor.update(schedulerSelectable);
    }

    public void invoke(Runnable work) throws IOException {
        this.throwIfSchedulerError();
        this.workQueue.offer(new Work(work));
        this.signalWorkQueue();
    }

    public void invoke(Runnable work, Duration delay) throws IOException {
        this.throwIfSchedulerError();
        this.workQueue.offer(new Work(work, delay));
        this.signalWorkQueue();
    }

    private void throwIfSchedulerError() {
        RejectedExecutionException rejectedException = (RejectedExecutionException)this.reactor.attachments().get(RejectedExecutionException.class, RejectedExecutionException.class);
        if (rejectedException != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new RejectedExecutionException(rejectedException.getMessage(), rejectedException));
        }
        if (!this.ioSignal.sink().isOpen()) {
            throw this.logger.logExceptionAsError((RuntimeException)new RejectedExecutionException("ReactorDispatcher instance is closed."));
        }
    }

    private void signalWorkQueue() throws IOException {
        try {
            ByteBuffer oneByteBuffer = ByteBuffer.allocate(1);
            while (this.ioSignal.sink().write(oneByteBuffer) == 0) {
                oneByteBuffer = ByteBuffer.allocate(1);
            }
        }
        catch (ClosedChannelException ignorePipeClosedDuringReactorShutdown) {
            this.logger.info("signalWorkQueue failed with an error: {}", new Object[]{ignorePipeClosedDuringReactorShutdown});
        }
    }

    private static final class Work {
        private final DispatchHandler dispatchHandler;
        private final Duration delay;

        Work(Runnable work) {
            this(work, null);
        }

        Work(Runnable work, Duration delay) {
            this.dispatchHandler = new DispatchHandler(work);
            this.delay = delay;
        }
    }

    private final class CloseHandler
    implements Selectable.Callback {
        private CloseHandler() {
        }

        public void run(Selectable selectable) {
            try {
                if (ReactorDispatcher.this.ioSignal.sink().isOpen()) {
                    ReactorDispatcher.this.ioSignal.sink().close();
                }
            }
            catch (IOException ioException) {
                ReactorDispatcher.this.logger.error("CloseHandler.run() sink().close() failed with an error. %s", new Object[]{ioException});
            }
            ReactorDispatcher.this.workScheduler.run(null);
            try {
                if (ReactorDispatcher.this.ioSignal.source().isOpen()) {
                    ReactorDispatcher.this.ioSignal.source().close();
                }
            }
            catch (IOException ioException) {
                ReactorDispatcher.this.logger.error("CloseHandler.run() source().close() failed with an error %s", new Object[]{ioException});
            }
        }
    }

    private final class WorkScheduler
    implements Selectable.Callback {
        private WorkScheduler() {
        }

        public void run(Selectable selectable) {
            Work topWork;
            try {
                ByteBuffer oneKbByteBuffer = ByteBuffer.allocate(1024);
                while (ReactorDispatcher.this.ioSignal.source().read(oneKbByteBuffer) > 0) {
                    oneKbByteBuffer = ByteBuffer.allocate(1024);
                }
            }
            catch (ClosedChannelException ignorePipeClosedDuringReactorShutdown) {
                ReactorDispatcher.this.logger.info("WorkScheduler.run() failed with an error: %s", new Object[]{ignorePipeClosedDuringReactorShutdown});
            }
            catch (IOException ioException) {
                ReactorDispatcher.this.logger.error("WorkScheduler.run() failed with an error: %s", new Object[]{ioException});
                throw ReactorDispatcher.this.logger.logExceptionAsError(new RuntimeException(ioException));
            }
            while ((topWork = (Work)ReactorDispatcher.this.workQueue.poll()) != null) {
                if (topWork.delay != null) {
                    ReactorDispatcher.this.reactor.schedule((int)topWork.delay.toMillis(), (Handler)topWork.dispatchHandler);
                    continue;
                }
                topWork.dispatchHandler.onTimerTask(null);
            }
        }
    }
}

