/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.AmqpErrorCode;
import com.azure.core.amqp.implementation.handler.WebSocketsConnectionHandler;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.microsoft.azure.proton.transport.proxy.ProxyConfiguration;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;

public class WebSocketsProxyConnectionHandler
extends WebSocketsConnectionHandler {
    private static final String HTTPS_URI_FORMAT = "https://%s:%s";
    private static final String PROXY_SELECTOR_HAS_BEEN_MODIFIED = "ProxySelector has been modified.";
    private final ClientLogger logger = new ClientLogger(WebSocketsProxyConnectionHandler.class);
    private final String amqpHostname;
    private final String remoteHost;
    private final ProxyOptions proxyOptions;

    public WebSocketsProxyConnectionHandler(String connectionId, String amqpHostname, ProxyOptions proxyOptions, String product, String clientVersion) {
        super(connectionId, amqpHostname, product, clientVersion);
        this.amqpHostname = Objects.requireNonNull(amqpHostname, "'amqpHostname' cannot be null.");
        this.proxyOptions = Objects.requireNonNull(proxyOptions, "'proxyConfiguration' cannot be null.");
        this.remoteHost = amqpHostname + ":" + 443;
    }

    public static boolean shouldUseProxy(String hostname) {
        Objects.requireNonNull(hostname, "'hostname' cannot be null.");
        URI uri = WebSocketsProxyConnectionHandler.createURI(hostname, 443);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return false;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return WebSocketsProxyConnectionHandler.isProxyAddressLegal(proxies);
    }

    @Override
    public void onConnectionInit(Event event) {
        Connection connection = event.getConnection();
        this.logger.info("onConnectionInit host[{}], connectionId[{}]", new Object[]{this.remoteHost, this.getConnectionId()});
        connection.setHostname(this.remoteHost);
        connection.setContainer(this.getConnectionId());
        HashMap properties = new HashMap();
        this.getConnectionProperties().forEach((key, value) -> properties.put(Symbol.getSymbol((String)key), value));
        connection.setProperties(properties);
        connection.open();
    }

    @Override
    public String getHostname() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getHostString();
    }

    @Override
    public int getProtocolPort() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getPort();
    }

    @Override
    public void onTransportError(Event event) {
        int port;
        boolean isProxyConfigured;
        super.onTransportError(event);
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (connection == null || transport == null) {
            return;
        }
        ErrorCondition errorCondition = transport.getCondition();
        if (errorCondition == null || !errorCondition.getCondition().equals(ConnectionError.FRAMING_ERROR) && !errorCondition.getCondition().equals(AmqpErrorCode.PROTON_IO_ERROR)) {
            return;
        }
        String hostName = event.getReactor().getConnectionAddress(connection);
        ProxySelector proxySelector = ProxySelector.getDefault();
        boolean bl = isProxyConfigured = proxySelector != null || this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured();
        if (!isProxyConfigured || CoreUtils.isNullOrEmpty((CharSequence)hostName)) {
            return;
        }
        String[] hostNameParts = hostName.split(":");
        if (hostNameParts.length != 2) {
            this.logger.warning("Invalid hostname: {}", new Object[]{hostName});
            return;
        }
        try {
            port = Integer.parseInt(hostNameParts[1]);
        }
        catch (NumberFormatException ignore) {
            this.logger.warning("Invalid port number: {}", new Object[]{hostNameParts[1]});
            return;
        }
        IOException ioException = new IOException(errorCondition.getDescription());
        URI url = WebSocketsProxyConnectionHandler.createURI(this.amqpHostname, 443);
        InetSocketAddress address = new InetSocketAddress(hostNameParts[0], port);
        this.logger.error(String.format("Failed to connect to url: '%s', proxy host: '%s'", url, address.getHostString()), new Object[]{ioException});
        if (proxySelector != null) {
            proxySelector.connectFailed(url, address, ioException);
        }
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        super.addTransportLayers(event, transport);
        ProxyImpl proxy = this.proxyOptions != null && this.proxyOptions != ProxyOptions.SYSTEM_DEFAULTS ? new ProxyImpl(this.getProtonConfiguration()) : new ProxyImpl();
        String hostname = event.getConnection().getHostname();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        proxy.configure(hostname, null, (ProxyHandler)proxyHandler, (Transport)transport);
        transport.addTransportLayer((TransportLayer)proxy);
        this.logger.info("addProxyHandshake: hostname[{}]", new Object[]{hostname});
    }

    private InetSocketAddress getProxyAddress() {
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured()) {
            return (InetSocketAddress)this.proxyOptions.getProxyAddress().address();
        }
        URI serviceUri = WebSocketsProxyConnectionHandler.createURI(this.amqpHostname, 443);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(PROXY_SELECTOR_HAS_BEEN_MODIFIED));
        }
        List<Proxy> proxies = proxySelector.select(serviceUri);
        if (!WebSocketsProxyConnectionHandler.isProxyAddressLegal(proxies)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(PROXY_SELECTOR_HAS_BEEN_MODIFIED));
        }
        Proxy proxy = proxies.get(0);
        return (InetSocketAddress)proxy.address();
    }

    private ProxyConfiguration getProtonConfiguration() {
        com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType type = this.getProtonAuthType(this.proxyOptions.getAuthentication());
        String username = this.proxyOptions.hasUserDefinedCredentials() ? this.proxyOptions.getCredential().getUserName() : null;
        String password = this.proxyOptions.hasUserDefinedCredentials() ? new String(this.proxyOptions.getCredential().getPassword()) : null;
        return new ProxyConfiguration(type, this.proxyOptions.getProxyAddress(), username, password);
    }

    private com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType getProtonAuthType(ProxyAuthenticationType type) {
        switch (type) {
            case DIGEST: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.DIGEST;
            }
            case BASIC: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.BASIC;
            }
            case NONE: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.NONE;
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("This authentication type is unknown:" + type.name()));
    }

    private static URI createURI(String hostname, int port) {
        return URI.create(String.format(Locale.ROOT, HTTPS_URI_FORMAT, hostname, port));
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).type() == Proxy.Type.HTTP && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }
}

