/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;

public class ConnectionStringProperties {
    private static final String TOKEN_VALUE_SEPARATOR = "=";
    private static final String TOKEN_VALUE_PAIR_DELIMITER = ";";
    private static final String SCHEME = "sb";
    private static final String ENDPOINT = "Endpoint";
    private static final String SHARED_ACCESS_KEY_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY = "SharedAccessKey";
    private static final String ENTITY_PATH = "EntityPath";
    private static final String ERROR_MESSAGE_FORMAT = "Could not parse 'connectionString'. Expected format: 'Endpoint={endpoint};SharedAccessKeyName={sharedAccessKeyName};SharedAccessKey={sharedAccessKey};EntityPath={eventHubName}'. Actual: %s";
    private final URI endpoint;
    private final String entityPath;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;

    public ConnectionStringProperties(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        if (connectionString.isEmpty()) {
            throw new IllegalArgumentException("'connectionString' cannot be an empty string.");
        }
        String[] tokenValuePairs = connectionString.split(TOKEN_VALUE_PAIR_DELIMITER);
        URI endpoint = null;
        String entityPath = null;
        String sharedAccessKeyName = null;
        String sharedAccessKeyValue = null;
        for (String tokenValuePair : tokenValuePairs) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException(String.format(Locale.US, "Connection string has invalid key value pair: %s", tokenValuePair));
            }
            String key = pair[0].trim();
            String value = pair[1].trim();
            if (key.equalsIgnoreCase(ENDPOINT)) {
                try {
                    endpoint = new URI(value);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(String.format(Locale.US, "Invalid endpoint: %s", tokenValuePair), e);
                }
                if (SCHEME.equalsIgnoreCase(endpoint.getScheme())) continue;
                throw new IllegalArgumentException(String.format(Locale.US, "Endpoint is not the correct scheme. Expected: %s. Actual Endpoint: %s", SCHEME, endpoint.toString()));
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_NAME)) {
                sharedAccessKeyName = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY)) {
                sharedAccessKeyValue = value;
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH)) {
                entityPath = value;
                continue;
            }
            throw new IllegalArgumentException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
        if (endpoint == null || sharedAccessKeyName == null || sharedAccessKeyValue == null) {
            throw new IllegalArgumentException(String.format(Locale.US, ERROR_MESSAGE_FORMAT, connectionString));
        }
        this.endpoint = endpoint;
        this.entityPath = entityPath;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.sharedAccessKey = sharedAccessKeyValue;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }
}

