/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum AmqpErrorCondition {
    NOT_FOUND("amqp:not-found"),
    UNAUTHORIZED_ACCESS("amqp:unauthorized-access"),
    RESOURCE_LIMIT_EXCEEDED("amqp:resource-limit-exceeded"),
    NOT_ALLOWED("amqp:not-allowed"),
    INTERNAL_ERROR("amqp:internal-error"),
    ILLEGAL_STATE("amqp:illegal-state"),
    NOT_IMPLEMENTED("amqp:not-implemented"),
    LINK_STOLEN("amqp:link:stolen"),
    LINK_PAYLOAD_SIZE_EXCEEDED("amqp:link:message-size-exceeded"),
    LINK_DETACH_FORCED("amqp:link:detach-forced"),
    CONNECTION_FORCED("amqp:connection:forced"),
    SERVER_BUSY_ERROR("com.microsoft:server-busy"),
    ARGUMENT_ERROR("com.microsoft:argument-error"),
    ARGUMENT_OUT_OF_RANGE_ERROR("com.microsoft:argument-out-of-range"),
    ENTITY_DISABLED_ERROR("com.microsoft:entity-disabled"),
    PARTITION_NOT_OWNED_ERROR("com.microsoft:partition-not-owned"),
    STORE_LOCK_LOST_ERROR("com.microsoft:store-lock-lost"),
    PUBLISHER_REVOKED_ERROR("com.microsoft:publisher-revoked"),
    TIMEOUT_ERROR("com.microsoft:timeout"),
    TRACKING_ID_PROPERTY("com.microsoft:tracking-id"),
    PROTON_IO("proton:io");

    private static final Map<String, AmqpErrorCondition> ERROR_CONSTANT_MAP;
    private final String errorCondition;

    private AmqpErrorCondition(String errorCondition) {
        this.errorCondition = errorCondition;
    }

    public String getErrorCondition() {
        return this.errorCondition;
    }

    public static AmqpErrorCondition fromString(String errorCondition) {
        Objects.requireNonNull(errorCondition);
        return ERROR_CONSTANT_MAP.get(errorCondition);
    }

    static {
        ERROR_CONSTANT_MAP = new HashMap<String, AmqpErrorCondition>();
        for (AmqpErrorCondition error : AmqpErrorCondition.values()) {
            ERROR_CONSTANT_MAP.put(error.getErrorCondition(), error);
        }
    }
}

