// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an update to a single prompt completion when the service is streaming updates
 * using Server Sent Events (SSE).
 * Generally, `n` choices are generated per provided prompt with a default value of 1.
 * Token limits and other settings may limit the number of choices generated.
 */
@Immutable
public final class StreamingChatChoiceUpdate implements JsonSerializable<StreamingChatChoiceUpdate> {

    /*
     * The ordered index associated with this chat completions choice.
     */
    @Generated
    private final int index;

    /*
     * The reason that this chat completions choice completed its generated.
     */
    @Generated
    private final CompletionsFinishReason finishReason;

    /*
     * An update to the chat message for a given chat completions prompt.
     */
    @Generated
    private final StreamingChatResponseMessageUpdate delta;

    /**
     * Creates an instance of StreamingChatChoiceUpdate class.
     *
     * @param index the index value to set.
     * @param finishReason the finishReason value to set.
     * @param delta the delta value to set.
     */
    @Generated
    private StreamingChatChoiceUpdate(int index, CompletionsFinishReason finishReason,
        StreamingChatResponseMessageUpdate delta) {
        this.index = index;
        this.finishReason = finishReason;
        this.delta = delta;
    }

    /**
     * Get the index property: The ordered index associated with this chat completions choice.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the finishReason property: The reason that this chat completions choice completed its generated.
     *
     * @return the finishReason value.
     */
    @Generated
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /**
     * Get the delta property: An update to the chat message for a given chat completions prompt.
     *
     * @return the delta value.
     */
    @Generated
    public StreamingChatResponseMessageUpdate getDelta() {
        return this.delta;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("delta", this.delta);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StreamingChatChoiceUpdate from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StreamingChatChoiceUpdate if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StreamingChatChoiceUpdate.
     */
    @Generated
    public static StreamingChatChoiceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            CompletionsFinishReason finishReason = null;
            StreamingChatResponseMessageUpdate delta = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                } else if ("delta".equals(fieldName)) {
                    delta = StreamingChatResponseMessageUpdate.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new StreamingChatChoiceUpdate(index, finishReason, delta);
        });
    }
}
