// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Representation of the response data from an embeddings request.
 * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
 * recommendations, and other similar scenarios.
 */
@Immutable
public final class EmbeddingsResult implements JsonSerializable<EmbeddingsResult> {

    /*
     * Embedding values for the prompts submitted in the request.
     */
    @Generated
    private final List<EmbeddingItem> data;

    /*
     * Usage counts for tokens input using the embeddings API.
     */
    @Generated
    private final EmbeddingsUsage usage;

    /*
     * The model ID used to generate this result.
     */
    @Generated
    private final String model;

    /**
     * Get the data property: Embedding values for the prompts submitted in the request.
     *
     * @return the data value.
     */
    @Generated
    public List<EmbeddingItem> getData() {
        return this.data;
    }

    /**
     * Get the usage property: Usage counts for tokens input using the embeddings API.
     *
     * @return the usage value.
     */
    @Generated
    public EmbeddingsUsage getUsage() {
        return this.usage;
    }

    /**
     * Get the model property: The model ID used to generate this result.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("usage", this.usage);
        jsonWriter.writeStringField("model", this.model);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbeddingsResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbeddingsResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbeddingsResult.
     */
    @Generated
    public static EmbeddingsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            List<EmbeddingItem> data = null;
            EmbeddingsUsage usage = null;
            String model = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> EmbeddingItem.fromJson(reader1));
                } else if ("usage".equals(fieldName)) {
                    usage = EmbeddingsUsage.fromJson(reader);
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new EmbeddingsResult(id, data, usage, model);
        });
    }

    /*
     * Unique identifier for the embeddings result.
     */
    @Generated
    private final String id;

    /**
     * Creates an instance of EmbeddingsResult class.
     *
     * @param id the id value to set.
     * @param data the data value to set.
     * @param usage the usage value to set.
     * @param model the model value to set.
     */
    @Generated
    private EmbeddingsResult(String id, List<EmbeddingItem> data, EmbeddingsUsage usage, String model) {
        this.id = id;
        this.data = data;
        this.usage = usage;
        this.model = model;
    }

    /**
     * Get the id property: Unique identifier for the embeddings result.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }
}
