// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;

/**
 * A structured chat content item containing an image reference.
 */
@Immutable
public final class ChatMessageImageContentItem extends ChatMessageContentItem {

    /*
     * The discriminated object type.
     */
    @Generated
    private String type = "image_url";

    /*
     * An internet location, which must be accessible to the model,from which the image may be retrieved.
     */
    @Generated
    private final ChatMessageImageUrl imageUrl;

    /**
     * Creates an instance of ChatMessageImageContentItem class.
     *
     * @param imageUrl the imageUrl value to set.
     */
    @Generated
    public ChatMessageImageContentItem(ChatMessageImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    /**
     * Creates an instance of ChatMessageImageContentItem class.
     *
     * @param filePath path to the imageFile.
     * @param imageFormat format of the image
     * @throws RuntimeException If an error occurs while reading the file or file not found.
     */
    public ChatMessageImageContentItem(Path filePath, String imageFormat) {
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String encodedFile = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
            String urlTemplate = "data:image/%s;base64,%s";
            this.imageUrl = new ChatMessageImageUrl(String.format(urlTemplate, imageFormat, encodedFile));
        } catch (FileNotFoundException e) {
            throw new RuntimeException("Local file not found.", e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get the type property: The discriminated object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the imageUrl property: An internet location, which must be accessible to the model,from which the image may
     * be retrieved.
     *
     * @return the imageUrl value.
     */
    @Generated
    public ChatMessageImageUrl getImageUrl() {
        return this.imageUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", this.imageUrl);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatMessageImageContentItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatMessageImageContentItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatMessageImageContentItem.
     */
    @Generated
    public static ChatMessageImageContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatMessageImageUrl imageUrl = null;
            String type = "image_url";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = ChatMessageImageUrl.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatMessageImageContentItem deserializedChatMessageImageContentItem
                = new ChatMessageImageContentItem(imageUrl);
            deserializedChatMessageImageContentItem.type = type;
            return deserializedChatMessageImageContentItem;
        });
    }
}
