// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents a generic policy for how a chat completions tool may be selected.
 */
public final class ChatCompletionsToolChoicePreset extends ExpandableStringEnum<ChatCompletionsToolChoicePreset> {

    /**
     * Specifies that the model may either use any of the tools provided in this chat completions request or
     * instead return a standard chat completions response as if no tools were provided.
     */
    @Generated
    public static final ChatCompletionsToolChoicePreset AUTO = fromString("auto");

    /**
     * Specifies that the model should not respond with a tool call and should instead provide a standard chat
     * completions response. Response content may still be influenced by the provided tool definitions.
     */
    @Generated
    public static final ChatCompletionsToolChoicePreset NONE = fromString("none");

    /**
     * Specifies that the model should respond with a call to one or more tools.
     */
    @Generated
    public static final ChatCompletionsToolChoicePreset REQUIRED = fromString("required");

    /**
     * Creates a new instance of ChatCompletionsToolChoicePreset value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ChatCompletionsToolChoicePreset() {
    }

    /**
     * Creates or finds a ChatCompletionsToolChoicePreset from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ChatCompletionsToolChoicePreset.
     */
    @Generated
    public static ChatCompletionsToolChoicePreset fromString(String name) {
        return fromString(name, ChatCompletionsToolChoicePreset.class);
    }

    /**
     * Gets known ChatCompletionsToolChoicePreset values.
     *
     * @return known ChatCompletionsToolChoicePreset values.
     */
    @Generated
    public static Collection<ChatCompletionsToolChoicePreset> values() {
        return values(ChatCompletionsToolChoicePreset.class);
    }
}
