// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A response format for Chat Completions that emits text responses. This is the default response format.
 */
@Immutable
public final class ChatCompletionsResponseFormatText extends ChatCompletionsResponseFormat {

    /*
     * The response format type to use for chat completions.
     */
    @Generated
    private String type = "text";

    /**
     * Creates an instance of ChatCompletionsResponseFormatText class.
     */
    @Generated
    public ChatCompletionsResponseFormatText() {
    }

    /**
     * Get the type property: The response format type to use for chat completions.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormatText from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormatText if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormatText.
     */
    @Generated
    public static ChatCompletionsResponseFormatText fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsResponseFormatText deserializedChatCompletionsResponseFormatText
                = new ChatCompletionsResponseFormatText();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChatCompletionsResponseFormatText.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionsResponseFormatText;
        });
    }
}
