// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A tool call to a function tool, issued by the model in evaluation of a configured function tool, that represents
 * a function invocation needed for a subsequent chat completions request to resolve.
 */
@Immutable
public final class ChatCompletionsFunctionToolCall extends ChatCompletionsToolCall {
    /*
     * The object type.
     */
    @Generated
    private String type = "function";

    /*
     * The details of the function invocation requested by the tool call.
     */
    @Generated
    private FunctionCall function;

    /**
     * Creates an instance of ChatCompletionsFunctionToolCall class.
     *
     * @param id the id value to set.
     * @param function the function value to set.
     */
    public ChatCompletionsFunctionToolCall(String id, FunctionCall function) {
        super(id, function);
        this.function = function;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the function property: The details of the function invocation requested by the tool call.
     *
     * @return the function value.
     */
    @Generated
    public FunctionCall getFunction() {
        return this.function;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("function", this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsFunctionToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsFunctionToolCall if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsFunctionToolCall.
     */
    @Generated
    public static ChatCompletionsFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            FunctionCall function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("function".equals(fieldName)) {
                    function = FunctionCall.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsFunctionToolCall deserializedChatCompletionsFunctionToolCall
                = new ChatCompletionsFunctionToolCall(id, function);
            deserializedChatCompletionsFunctionToolCall.type = type;

            return deserializedChatCompletionsFunctionToolCall;
        });
    }
}
