/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.CompletionsFinishReason;
import com.azure.ai.inference.models.StreamingChatResponseMessageUpdate;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class StreamingChatChoiceUpdate
implements JsonSerializable<StreamingChatChoiceUpdate> {
    private final int index;
    private final CompletionsFinishReason finishReason;
    private final StreamingChatResponseMessageUpdate delta;

    private StreamingChatChoiceUpdate(int index, CompletionsFinishReason finishReason, StreamingChatResponseMessageUpdate delta) {
        this.index = index;
        this.finishReason = finishReason;
        this.delta = delta;
    }

    public int getIndex() {
        return this.index;
    }

    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    public StreamingChatResponseMessageUpdate getDelta() {
        return this.delta;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("delta", (JsonSerializable)this.delta);
        return jsonWriter.writeEndObject();
    }

    public static StreamingChatChoiceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (StreamingChatChoiceUpdate)jsonReader.readObject(reader -> {
            int index = 0;
            CompletionsFinishReason finishReason = null;
            StreamingChatResponseMessageUpdate delta = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    delta = StreamingChatResponseMessageUpdate.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new StreamingChatChoiceUpdate(index, finishReason, delta);
        });
    }
}

