/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.EmbeddingItem;
import com.azure.ai.inference.models.EmbeddingsUsage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EmbeddingsResult
implements JsonSerializable<EmbeddingsResult> {
    private final List<EmbeddingItem> data;
    private final EmbeddingsUsage usage;
    private final String model;
    private final String id;

    public List<EmbeddingItem> getData() {
        return this.data;
    }

    public EmbeddingsUsage getUsage() {
        return this.usage;
    }

    public String getModel() {
        return this.model;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeStringField("model", this.model);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingsResult fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingsResult)jsonReader.readObject(reader -> {
            String id = null;
            List data = null;
            EmbeddingsUsage usage = null;
            String model = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> EmbeddingItem.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = EmbeddingsUsage.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new EmbeddingsResult(id, data, usage, model);
        });
    }

    private EmbeddingsResult(String id, List<EmbeddingItem> data, EmbeddingsUsage usage, String model) {
        this.id = id;
        this.data = data;
        this.usage = usage;
        this.model = model;
    }

    public String getId() {
        return this.id;
    }
}

