/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatChoice;
import com.azure.ai.inference.models.CompletionsUsage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class ChatCompletions
implements JsonSerializable<ChatCompletions> {
    private final String id;
    private final long created;
    private final String model;
    private final CompletionsUsage usage;
    private final List<ChatChoice> choices;

    private ChatCompletions(String id, OffsetDateTime created, String model, CompletionsUsage usage, List<ChatChoice> choices) {
        this.id = id;
        this.created = created == null ? 0L : created.toEpochSecond();
        this.model = model;
        this.usage = usage;
        this.choices = choices;
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreated() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public String getModel() {
        return this.model;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public ChatChoice getChoice() {
        return this.choices.get(0);
    }

    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created", this.created);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeArrayField("choices", this.choices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletions fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletions)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime created = null;
            String model = null;
            CompletionsUsage usage = null;
            List choices = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    created = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = CompletionsUsage.fromJson(reader);
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    choices = reader.readArray(reader1 -> ChatChoice.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatCompletions(id, created, model, usage, choices);
        });
    }
}

