/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatResponseMessage;
import com.azure.ai.inference.models.CompletionsFinishReason;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatChoice
implements JsonSerializable<ChatChoice> {
    private final int index;
    private final CompletionsFinishReason finishReason;
    private final ChatResponseMessage message;

    private ChatChoice(int index, CompletionsFinishReason finishReason, ChatResponseMessage message) {
        this.index = index;
        this.finishReason = finishReason;
        this.message = message;
    }

    public int getIndex() {
        return this.index;
    }

    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    public ChatResponseMessage getMessage() {
        return this.message;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("message", (JsonSerializable)this.message);
        return jsonWriter.writeEndObject();
    }

    public static ChatChoice fromJson(JsonReader jsonReader) throws IOException {
        return (ChatChoice)jsonReader.readObject(reader -> {
            int index = 0;
            CompletionsFinishReason finishReason = null;
            ChatResponseMessage message = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = ChatResponseMessage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatChoice(index, finishReason, message);
        });
    }
}

