/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.implementation;

import com.azure.ai.inference.ModelServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class EmbeddingsClientImpl {
    private final EmbeddingsClientService service;
    private final String endpoint;
    private final ModelServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public ModelServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EmbeddingsClientImpl(String endpoint, ModelServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EmbeddingsClientImpl(HttpPipeline httpPipeline, String endpoint, ModelServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EmbeddingsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, ModelServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (EmbeddingsClientService)RestProxy.create(EmbeddingsClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> embedWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.embed(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> embedWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.embedSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getModelInfoWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getModelInfo(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getModelInfoWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getModelInfoSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="EmbeddingsClient")
    public static interface EmbeddingsClientService {
        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> embed(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> embedSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getModelInfo(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getModelInfoSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

