/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.ChatCompletionClientTracer;
import com.azure.ai.inference.ChatCompletionsClientBuilder;
import com.azure.ai.inference.implementation.ChatCompletionsClientImpl;
import com.azure.ai.inference.implementation.ChatCompletionsUtils;
import com.azure.ai.inference.implementation.InferenceServerSentEvents;
import com.azure.ai.inference.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.inference.implementation.models.CompleteRequest;
import com.azure.ai.inference.models.ChatCompletions;
import com.azure.ai.inference.models.ChatCompletionsOptions;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.ai.inference.models.StreamingChatCompletionsUpdate;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ChatCompletionsClientBuilder.class, isAsync=true)
public final class ChatCompletionsAsyncClient {
    private final ChatCompletionsClientImpl serviceClient;
    private final ChatCompletionClientTracer tracer;

    ChatCompletionsAsyncClient(ChatCompletionsClientImpl serviceClient, ChatCompletionClientTracer tracer) {
        this.serviceClient = serviceClient;
        this.tracer = tracer;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> completeWithResponse(BinaryData completeRequest, RequestOptions requestOptions) {
        return this.serviceClient.completeWithResponseAsync(completeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamingChatCompletionsUpdate> completeStream(ChatCompletionsOptions options) {
        ChatCompletionsOptionsAccessHelper.setStream(options, true);
        RequestOptions requestOptions = new RequestOptions();
        ChatCompletionClientTracer.StreamingCompleteOperation operation = (arg0, arg1) -> this.completionStreaming(arg0, arg1);
        return this.tracer.traceStreamingCompletion(options, operation, BinaryData.fromObject((Object)options), requestOptions);
    }

    private Flux<StreamingChatCompletionsUpdate> completionStreaming(BinaryData completeRequest, RequestOptions requestOptions) {
        Flux responseStream = this.completeWithResponse(completeRequest, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        InferenceServerSentEvents<StreamingChatCompletionsUpdate> chatCompletionsStream = new InferenceServerSentEvents<StreamingChatCompletionsUpdate>((Flux<ByteBuffer>)responseStream, StreamingChatCompletionsUpdate.class);
        return chatCompletionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatCompletions> complete(String prompt) {
        return this.complete(ChatCompletionsUtils.defaultCompleteOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatCompletions> complete(ChatCompletionsOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        CompleteRequest completeRequestObj = new CompleteRequest(options.getMessages()).setFrequencyPenalty(options.getFrequencyPenalty()).setStream(options.isStream()).setPresencePenalty(options.getPresencePenalty()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxTokens(options.getMaxTokens()).setResponseFormat(options.getResponseFormat()).setStop(options.getStop()).setTools(options.getTools()).setToolChoice(options.getToolChoice()).setSeed(options.getSeed()).setModel(options.getModel());
        BinaryData completeRequest = BinaryData.fromObject((Object)completeRequestObj);
        ExtraParameters extraParams = options.getExtraParams();
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        ChatCompletionClientTracer.CompleteOperation operation = (arg0, arg1) -> this.completeWithResponse(arg0, arg1).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ChatCompletions)protocolMethodData.toObject(ChatCompletions.class));
        return this.tracer.traceComplete(options, operation, completeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ModelInfo> getModelInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getModelInfoWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ModelInfo)protocolMethodData.toObject(ModelInfo.class));
    }
}

