// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A representation of a chat message update as received in a streaming response.
 */
@Immutable
public final class StreamingChatResponseMessageUpdate implements JsonSerializable<StreamingChatResponseMessageUpdate> {

    /*
     * The chat role associated with the message. If present, should always be 'assistant'
     */
    @Generated
    private ChatRole role;

    /*
     * The content of the message.
     */
    @Generated
    private String content;

    /*
     * The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private List<StreamingChatResponseToolCallUpdate> toolCalls;

    /**
     * Creates an instance of StreamingChatResponseMessageUpdate class.
     */
    @Generated
    private StreamingChatResponseMessageUpdate() {
    }

    /**
     * Get the role property: The chat role associated with the message. If present, should always be 'assistant'.
     *
     * @return the role value.
     */
    @Generated
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<StreamingChatResponseToolCallUpdate> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StreamingChatResponseMessageUpdate from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StreamingChatResponseMessageUpdate if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StreamingChatResponseMessageUpdate.
     */
    @Generated
    public static StreamingChatResponseMessageUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StreamingChatResponseMessageUpdate deserializedStreamingChatResponseMessageUpdate
                = new StreamingChatResponseMessageUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedStreamingChatResponseMessageUpdate.role = ChatRole.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    deserializedStreamingChatResponseMessageUpdate.content = reader.getString();
                } else if ("tool_calls".equals(fieldName)) {
                    List<StreamingChatResponseToolCallUpdate> toolCalls
                        = reader.readArray(reader1 -> StreamingChatResponseToolCallUpdate.fromJson(reader1));
                    deserializedStreamingChatResponseMessageUpdate.toolCalls = toolCalls;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedStreamingChatResponseMessageUpdate;
        });
    }
}
