// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of AI model.
 */
public final class ModelType extends ExpandableStringEnum<ModelType> {

    /**
     * A model capable of generating embeddings from a text.
     */
    @Generated
    public static final ModelType EMBEDDINGS = fromString("embeddings");

    /**
     * A model capable of generating images from an image and text description.
     */
    @Generated
    public static final ModelType IMAGE_GENERATION = fromString("image_generation");

    /**
     * A text generation model.
     */
    @Generated
    public static final ModelType TEXT_GENERATION = fromString("text_generation");

    /**
     * A model capable of generating embeddings from an image.
     */
    @Generated
    public static final ModelType IMAGE_EMBEDDINGS = fromString("image_embeddings");

    /**
     * A text-to-audio generative model.
     */
    @Generated
    public static final ModelType AUDIO_GENERATION = fromString("audio_generation");

    /**
     * Creates a new instance of ModelType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ModelType() {
    }

    /**
     * Creates or finds a ModelType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ModelType.
     */
    @Generated
    public static ModelType fromString(String name) {
        return fromString(name, ModelType.class);
    }

    /**
     * Gets known ModelType values.
     *
     * @return known ModelType values.
     */
    @Generated
    public static Collection<ModelType> values() {
        return values(ModelType.class);
    }

    /**
     * A model capable of taking chat-formatted messages and generate responses.
     */
    @Generated
    public static final ModelType CHAT_COMPLETION = fromString("chat_completion");
}
