// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents some basic information about the AI model.
 */
@Immutable
public final class ModelInfo implements JsonSerializable<ModelInfo> {

    /*
     * The name of the AI model. For example: `Phi21`
     */
    @Generated
    private final String modelName;

    /*
     * The type of the AI model. A Unique identifier for the profile.
     */
    @Generated
    private final ModelType modelType;

    /*
     * The model provider name. For example: `Microsoft Research`
     */
    @Generated
    private final String modelProviderName;

    /**
     * Creates an instance of ModelInfo class.
     *
     * @param modelName the modelName value to set.
     * @param modelType the modelType value to set.
     * @param modelProviderName the modelProviderName value to set.
     */
    @Generated
    private ModelInfo(String modelName, ModelType modelType, String modelProviderName) {
        this.modelName = modelName;
        this.modelType = modelType;
        this.modelProviderName = modelProviderName;
    }

    /**
     * Get the modelName property: The name of the AI model. For example: `Phi21`.
     *
     * @return the modelName value.
     */
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Get the modelType property: The type of the AI model. A Unique identifier for the profile.
     *
     * @return the modelType value.
     */
    @Generated
    public ModelType getModelType() {
        return this.modelType;
    }

    /**
     * Get the modelProviderName property: The model provider name. For example: `Microsoft Research`.
     *
     * @return the modelProviderName value.
     */
    @Generated
    public String getModelProviderName() {
        return this.modelProviderName;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model_name", this.modelName);
        jsonWriter.writeStringField("model_type", this.modelType == null ? null : this.modelType.toString());
        jsonWriter.writeStringField("model_provider_name", this.modelProviderName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ModelInfo from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ModelInfo if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ModelInfo.
     */
    @Generated
    public static ModelInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String modelName = null;
            ModelType modelType = null;
            String modelProviderName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model_name".equals(fieldName)) {
                    modelName = reader.getString();
                } else if ("model_type".equals(fieldName)) {
                    modelType = ModelType.fromString(reader.getString());
                } else if ("model_provider_name".equals(fieldName)) {
                    modelProviderName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new ModelInfo(modelName, modelType, modelProviderName);
        });
    }
}
