// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an image with optional text.
 */
@Fluent
public final class EmbeddingInput implements JsonSerializable<EmbeddingInput> {

    /*
     * The input image, in PNG format.
     */
    @Generated
    private final String image;

    /*
     * Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     */
    @Generated
    private String text;

    /**
     * Creates an instance of EmbeddingInput class.
     *
     * @param image the image value to set.
     */
    @Generated
    public EmbeddingInput(String image) {
        this.image = image;
    }

    /**
     * Get the image property: The input image, in PNG format.
     *
     * @return the image value.
     */
    @Generated
    public String getImage() {
        return this.image;
    }

    /**
     * Get the text property: Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @param text the text value to set.
     * @return the EmbeddingInput object itself.
     */
    @Generated
    public EmbeddingInput setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbeddingInput from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbeddingInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbeddingInput.
     */
    @Generated
    public static EmbeddingInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String image = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    image = reader.getString();
                } else if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            EmbeddingInput deserializedEmbeddingInput = new EmbeddingInput(image);
            deserializedEmbeddingInput.text = text;
            return deserializedEmbeddingInput;
        });
    }
}
