// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the format that the model must output. Use this to enable JSON mode instead of the default text mode.
 * Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
 * via a system or user message.
 */
@Immutable
public class ChatCompletionsResponseFormat implements JsonSerializable<ChatCompletionsResponseFormat> {

    /*
     * The response format type to use for chat completions.
     */
    @Generated
    private String type = "ChatCompletionsResponseFormat";

    /**
     * Creates an instance of ChatCompletionsResponseFormat class.
     */
    @Generated
    public ChatCompletionsResponseFormat() {
    }

    /**
     * Get the type property: The response format type to use for chat completions.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormat from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormat.
     */
    @Generated
    public static ChatCompletionsResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return ChatCompletionsResponseFormatText.fromJson(readerToUse.reset());
                } else if ("json_object".equals(discriminatorValue)) {
                    return ChatCompletionsResponseFormatJsonObject.fromJson(readerToUse.reset());
                } else if ("json_schema".equals(discriminatorValue)) {
                    return ChatCompletionsResponseFormatJsonSchema.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static ChatCompletionsResponseFormat fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsResponseFormat deserializedChatCompletionsResponseFormat
                = new ChatCompletionsResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChatCompletionsResponseFormat.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionsResponseFormat;
        });
    }
}
