// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A tool selection of a specific, named function tool that will limit chat completions to using the named function.
 */
@Immutable
public class ChatCompletionsNamedToolChoice implements JsonSerializable<ChatCompletionsNamedToolChoice> {

    /*
     * The type of the tool. Currently, only `function` is supported.
     */
    @Generated
    private final String type = "function";

    /*
     * The function that should be called.
     */
    @Generated
    private final ChatCompletionsNamedToolChoiceFunction function;

    /**
     * Creates an instance of ChatCompletionsNamedToolChoice class.
     *
     * @param function the function value to set.
     */
    @Generated
    public ChatCompletionsNamedToolChoice(ChatCompletionsNamedToolChoiceFunction function) {
        this.function = function;
    }

    /**
     * Get the type property: The type of the tool. Currently, only `function` is supported.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the function property: The function that should be called.
     *
     * @return the function value.
     */
    @Generated
    public ChatCompletionsNamedToolChoiceFunction getFunction() {
        return this.function;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("function", this.function);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsNamedToolChoice from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsNamedToolChoice if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsNamedToolChoice.
     */
    @Generated
    public static ChatCompletionsNamedToolChoice fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsNamedToolChoiceFunction function = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = ChatCompletionsNamedToolChoiceFunction.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new ChatCompletionsNamedToolChoice(function);
        });
    }
}
