// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * The EmbedRequest model.
 */
@Fluent
public final class EmbedRequest implements JsonSerializable<EmbedRequest> {

    /*
     * Input text to embed, encoded as a string or array of tokens.
     * To embed multiple inputs in a single request, pass an array
     * of strings or array of token arrays.
     */
    @Generated
    private final List<String> input;

    /*
     * Optional. The number of dimensions the resulting output embeddings should have.
     * Passing null causes the model to use its default value.
     * Returns a 422 error if the model doesn't support the value or parameter.
     */
    @Generated
    private Integer dimensions;

    /*
     * Optional. The desired format for the returned embeddings.
     */
    @Generated
    private EmbeddingEncodingFormat encodingFormat;

    /*
     * Optional. The type of the input.
     * Returns a 422 error if the model doesn't support the value or parameter.
     */
    @Generated
    private EmbeddingInputType inputType;

    /*
     * ID of the specific AI model to use, if more than one model is available on the endpoint.
     */
    @Generated
    private String model;

    /*
     * Additional properties
     */
    @Generated
    private Map<String, BinaryData> additionalProperties;

    /**
     * Creates an instance of EmbedRequest class.
     *
     * @param input the input value to set.
     */
    @Generated
    public EmbedRequest(List<String> input) {
        this.input = input;
    }

    /**
     * Get the input property: Input text to embed, encoded as a string or array of tokens.
     * To embed multiple inputs in a single request, pass an array
     * of strings or array of token arrays.
     *
     * @return the input value.
     */
    @Generated
    public List<String> getInput() {
        return this.input;
    }

    /**
     * Get the dimensions property: Optional. The number of dimensions the resulting output embeddings should have.
     * Passing null causes the model to use its default value.
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @return the dimensions value.
     */
    @Generated
    public Integer getDimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: Optional. The number of dimensions the resulting output embeddings should have.
     * Passing null causes the model to use its default value.
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @param dimensions the dimensions value to set.
     * @return the EmbedRequest object itself.
     */
    @Generated
    public EmbedRequest setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the encodingFormat property: Optional. The desired format for the returned embeddings.
     *
     * @return the encodingFormat value.
     */
    @Generated
    public EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    /**
     * Set the encodingFormat property: Optional. The desired format for the returned embeddings.
     *
     * @param encodingFormat the encodingFormat value to set.
     * @return the EmbedRequest object itself.
     */
    @Generated
    public EmbedRequest setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    /**
     * Get the inputType property: Optional. The type of the input.
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @return the inputType value.
     */
    @Generated
    public EmbeddingInputType getInputType() {
        return this.inputType;
    }

    /**
     * Set the inputType property: Optional. The type of the input.
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @param inputType the inputType value to set.
     * @return the EmbedRequest object itself.
     */
    @Generated
    public EmbedRequest setInputType(EmbeddingInputType inputType) {
        this.inputType = inputType;
        return this;
    }

    /**
     * Get the model property: ID of the specific AI model to use, if more than one model is available on the endpoint.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: ID of the specific AI model to use, if more than one model is available on the endpoint.
     *
     * @param model the model value to set.
     * @return the EmbedRequest object itself.
     */
    @Generated
    public EmbedRequest setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the additionalProperties property: Additional properties.
     *
     * @return the additionalProperties value.
     */
    @Generated
    public Map<String, BinaryData> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Additional properties.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the EmbedRequest object itself.
     */
    @Generated
    public EmbedRequest setAdditionalProperties(Map<String, BinaryData> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("dimensions", this.dimensions);
        jsonWriter.writeStringField("encoding_format",
            this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeStringField("input_type", this.inputType == null ? null : this.inputType.toString());
        jsonWriter.writeStringField("model", this.model);
        if (additionalProperties != null) {
            for (Map.Entry<String, BinaryData> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeFieldName(additionalProperty.getKey());
                if (additionalProperty.getValue() == null) {
                    jsonWriter.writeNull();
                } else {
                    additionalProperty.getValue().writeTo(jsonWriter);
                }
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbedRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbedRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbedRequest.
     */
    @Generated
    public static EmbedRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> input = null;
            Integer dimensions = null;
            EmbeddingEncodingFormat encodingFormat = null;
            EmbeddingInputType inputType = null;
            String model = null;
            Map<String, BinaryData> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> reader1.getString());
                } else if ("dimensions".equals(fieldName)) {
                    dimensions = reader.getNullable(JsonReader::getInt);
                } else if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                } else if ("input_type".equals(fieldName)) {
                    inputType = EmbeddingInputType.fromString(reader.getString());
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }
                    additionalProperties.put(fieldName,
                        reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped())));
                }
            }
            EmbedRequest deserializedEmbedRequest = new EmbedRequest(input);
            deserializedEmbedRequest.dimensions = dimensions;
            deserializedEmbedRequest.encodingFormat = encodingFormat;
            deserializedEmbedRequest.inputType = inputType;
            deserializedEmbedRequest.model = model;
            deserializedEmbedRequest.additionalProperties = additionalProperties;
            return deserializedEmbedRequest;
        });
    }
}
