// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.ChatCompletionsResponseFormat;
import com.azure.ai.inference.models.ChatCompletionsToolDefinition;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * The CompleteRequest model.
 */
@Fluent
public final class CompleteRequest implements JsonSerializable<CompleteRequest> {

    /*
     * The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     */
    @Generated
    private final List<ChatRequestMessage> messages;

    /*
     * A value that influences the probability of generated tokens appearing based on their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     * Supported range is [-2, 2].
     */
    @Generated
    private Double frequencyPenalty;

    /*
     * A value indicating whether chat completions should be streamed for this request.
     */
    @Generated
    private Boolean stream;

    /*
     * A value that influences the probability of generated tokens appearing based on their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     * Supported range is [-2, 2].
     */
    @Generated
    private Double presencePenalty;

    /*
     * The sampling temperature to use that controls the apparent creativity of generated completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     */
    @Generated
    private Double temperature;

    /*
     * An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     */
    @Generated
    private Double topP;

    /*
     * The maximum number of tokens to generate.
     */
    @Generated
    private Integer maxTokens;

    /*
     * The format that the model must output. Use this to enable JSON mode instead of the default text mode.
     * Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
     * via a system or user message.
     */
    @Generated
    private ChatCompletionsResponseFormat responseFormat;

    /*
     * A collection of textual sequences that will end completions generation.
     */
    @Generated
    private List<String> stop;

    /*
     * A list of tools the model may request to call. Currently, only functions are supported as a tool. The model
     * may response with a function call request and provide the input arguments in JSON format for that function.
     */
    @Generated
    private List<ChatCompletionsToolDefinition> tools;

    /*
     * If specified, the model will configure which of the provided tools it can use for the chat completions response.
     */
    @Generated
    private BinaryData toolChoice;

    /*
     * If specified, the system will make a best effort to sample deterministically such that repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed.
     */
    @Generated
    private Long seed;

    /*
     * ID of the specific AI model to use, if more than one model is available on the endpoint.
     */
    @Generated
    private String model;

    /*
     * Additional properties
     */
    @Generated
    private Map<String, BinaryData> additionalProperties;

    /**
     * Creates an instance of CompleteRequest class.
     *
     * @param messages the messages value to set.
     */
    @Generated
    public CompleteRequest(List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    /**
     * Get the messages property: The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     *
     * @return the messages value.
     */
    @Generated
    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    /**
     * Get the frequencyPenalty property: A value that influences the probability of generated tokens appearing based on
     * their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     * Supported range is [-2, 2].
     *
     * @return the frequencyPenalty value.
     */
    @Generated
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    /**
     * Set the frequencyPenalty property: A value that influences the probability of generated tokens appearing based on
     * their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     * Supported range is [-2, 2].
     *
     * @param frequencyPenalty the frequencyPenalty value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    /**
     * Get the stream property: A value indicating whether chat completions should be streamed for this request.
     *
     * @return the stream value.
     */
    @Generated
    public Boolean isStream() {
        return this.stream;
    }

    /**
     * Set the stream property: A value indicating whether chat completions should be streamed for this request.
     *
     * @param stream the stream value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    /**
     * Get the presencePenalty property: A value that influences the probability of generated tokens appearing based on
     * their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     * Supported range is [-2, 2].
     *
     * @return the presencePenalty value.
     */
    @Generated
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    /**
     * Set the presencePenalty property: A value that influences the probability of generated tokens appearing based on
     * their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     * Supported range is [-2, 2].
     *
     * @param presencePenalty the presencePenalty value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    /**
     * Get the temperature property: The sampling temperature to use that controls the apparent creativity of generated
     * completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Set the temperature property: The sampling temperature to use that controls the apparent creativity of generated
     * completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     *
     * @param temperature the temperature value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Set the topP property: An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     * Supported range is [0, 1].
     *
     * @param topP the topP value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    /**
     * Get the maxTokens property: The maximum number of tokens to generate.
     *
     * @return the maxTokens value.
     */
    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    /**
     * Set the maxTokens property: The maximum number of tokens to generate.
     *
     * @param maxTokens the maxTokens value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    /**
     * Get the responseFormat property: The format that the model must output. Use this to enable JSON mode instead of
     * the default text mode.
     * Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
     * via a system or user message.
     *
     * @return the responseFormat value.
     */
    @Generated
    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: The format that the model must output. Use this to enable JSON mode instead of
     * the default text mode.
     * Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
     * via a system or user message.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * Get the stop property: A collection of textual sequences that will end completions generation.
     *
     * @return the stop value.
     */
    @Generated
    public List<String> getStop() {
        return this.stop;
    }

    /**
     * Set the stop property: A collection of textual sequences that will end completions generation.
     *
     * @param stop the stop value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    /**
     * Get the tools property: A list of tools the model may request to call. Currently, only functions are supported as
     * a tool. The model
     * may response with a function call request and provide the input arguments in JSON format for that function.
     *
     * @return the tools value.
     */
    @Generated
    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Set the tools property: A list of tools the model may request to call. Currently, only functions are supported as
     * a tool. The model
     * may response with a function call request and provide the input arguments in JSON format for that function.
     *
     * @param tools the tools value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    /**
     * Get the toolChoice property: If specified, the model will configure which of the provided tools it can use for
     * the chat completions response.
     *
     * @return the toolChoice value.
     */
    @Generated
    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    /**
     * Set the toolChoice property: If specified, the model will configure which of the provided tools it can use for
     * the chat completions response.
     *
     * @param toolChoice the toolChoice value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    /**
     * Get the seed property: If specified, the system will make a best effort to sample deterministically such that
     * repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed.
     *
     * @return the seed value.
     */
    @Generated
    public Long getSeed() {
        return this.seed;
    }

    /**
     * Set the seed property: If specified, the system will make a best effort to sample deterministically such that
     * repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed.
     *
     * @param seed the seed value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    /**
     * Get the model property: ID of the specific AI model to use, if more than one model is available on the endpoint.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: ID of the specific AI model to use, if more than one model is available on the endpoint.
     *
     * @param model the model value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the additionalProperties property: Additional properties.
     *
     * @return the additionalProperties value.
     */
    @Generated
    public Map<String, BinaryData> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Additional properties.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the CompleteRequest object itself.
     */
    @Generated
    public CompleteRequest setAdditionalProperties(Map<String, BinaryData> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("frequency_penalty", this.frequencyPenalty);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("presence_penalty", this.presencePenalty);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        jsonWriter.writeNumberField("max_tokens", this.maxTokens);
        jsonWriter.writeJsonField("response_format", this.responseFormat);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        jsonWriter.writeNumberField("seed", this.seed);
        jsonWriter.writeStringField("model", this.model);
        if (additionalProperties != null) {
            for (Map.Entry<String, BinaryData> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeFieldName(additionalProperty.getKey());
                if (additionalProperty.getValue() == null) {
                    jsonWriter.writeNull();
                } else {
                    additionalProperty.getValue().writeTo(jsonWriter);
                }
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CompleteRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CompleteRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CompleteRequest.
     */
    @Generated
    public static CompleteRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<ChatRequestMessage> messages = null;
            Double frequencyPenalty = null;
            Boolean stream = null;
            Double presencePenalty = null;
            Double temperature = null;
            Double topP = null;
            Integer maxTokens = null;
            ChatCompletionsResponseFormat responseFormat = null;
            List<String> stop = null;
            List<ChatCompletionsToolDefinition> tools = null;
            BinaryData toolChoice = null;
            Long seed = null;
            String model = null;
            Map<String, BinaryData> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> ChatRequestMessage.fromJson(reader1));
                } else if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = reader.getNullable(JsonReader::getDouble);
                } else if ("stream".equals(fieldName)) {
                    stream = reader.getNullable(JsonReader::getBoolean);
                } else if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = reader.getNullable(JsonReader::getDouble);
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getNullable(JsonReader::getDouble);
                } else if ("max_tokens".equals(fieldName)) {
                    maxTokens = reader.getNullable(JsonReader::getInt);
                } else if ("response_format".equals(fieldName)) {
                    responseFormat = ChatCompletionsResponseFormat.fromJson(reader);
                } else if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ChatCompletionsToolDefinition.fromJson(reader1));
                } else if ("tool_choice".equals(fieldName)) {
                    toolChoice
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("seed".equals(fieldName)) {
                    seed = reader.getNullable(JsonReader::getLong);
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }
                    additionalProperties.put(fieldName,
                        reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped())));
                }
            }
            CompleteRequest deserializedCompleteRequest = new CompleteRequest(messages);
            deserializedCompleteRequest.frequencyPenalty = frequencyPenalty;
            deserializedCompleteRequest.stream = stream;
            deserializedCompleteRequest.presencePenalty = presencePenalty;
            deserializedCompleteRequest.temperature = temperature;
            deserializedCompleteRequest.topP = topP;
            deserializedCompleteRequest.maxTokens = maxTokens;
            deserializedCompleteRequest.responseFormat = responseFormat;
            deserializedCompleteRequest.stop = stop;
            deserializedCompleteRequest.tools = tools;
            deserializedCompleteRequest.toolChoice = toolChoice;
            deserializedCompleteRequest.seed = seed;
            deserializedCompleteRequest.model = model;
            deserializedCompleteRequest.additionalProperties = additionalProperties;
            return deserializedCompleteRequest;
        });
    }
}
