// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference;

import com.azure.ai.inference.implementation.ImageEmbeddingsClientImpl;
import com.azure.ai.inference.implementation.models.ImageEmbedRequest;
import com.azure.ai.inference.models.EmbeddingsResult;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ImageEmbeddingInput;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import java.util.List;

/**
 * Initializes a new instance of the synchronous ImageEmbeddingsClient type.
 */
@ServiceClient(builder = ImageEmbeddingsClientBuilder.class)
public final class ImageEmbeddingsClient {

    @Generated
    private final ImageEmbeddingsClientImpl serviceClient;

    /**
     * Initializes an instance of ImageEmbeddingsClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    ImageEmbeddingsClient(ImageEmbeddingsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Return the embedding vectors for given images.
     * The method makes a REST API call to the `/images/embeddings` route on the given endpoint.
     * <p><strong>Header Parameters</strong></p>
     * <table border="1">
     * <caption>Header Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>extra-parameters</td><td>String</td><td>No</td><td>Controls what happens if extra parameters, undefined
     * by the REST API,
     * are passed in the JSON request payload.
     * This sets the HTTP request header `extra-parameters`. Allowed values: "error", "drop", "pass-through".</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addHeader}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     input (Required): [
     *          (Required){
     *             image: String (Required)
     *             text: String (Optional)
     *         }
     *     ]
     *     dimensions: Integer (Optional)
     *     encoding_format: String(base64/binary/float/int8/ubinary/uint8) (Optional)
     *     input_type: String(text/query/document) (Optional)
     *     model: String (Optional)
     *      (Optional): {
     *         String: BinaryData (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     data (Required): [
     *          (Required){
     *             embedding: BinaryData (Required)
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     *     model: String (Required)
     * }
     * }
     * </pre>
     *
     * @param body request options to pass to the endpoint using images embeddings path.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> embedWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.embedWithResponse(body, requestOptions);
    }

    /**
     * Return the embedding vectors for given text prompts.
     * The method makes a REST API call to the `/embeddings` route on the given endpoint.
     *
     * @param inputs ImageEmbeddingInput instances to embed, encoded as a string or array of tokens.
     * To embed multiple inputs in a single request, pass an array
     * of strings or array of token arrays.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EmbeddingsResult embed(List<ImageEmbeddingInput> inputs) {
        // Generated convenience method for embedWithResponse
        RequestOptions requestOptions = new RequestOptions();
        ImageEmbedRequest embedRequestObj = new ImageEmbedRequest(inputs);
        BinaryData embedRequest = BinaryData.fromObject(embedRequestObj);
        return embedWithResponse(embedRequest, requestOptions).getValue().toObject(EmbeddingsResult.class);
    }

    /**
     * Returns information about the AI model.
     * The method makes a REST API call to the `/info` route on the given endpoint.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     model_name: String (Required)
     *     model_type: String(embeddings/image_generation/text_generation/image_embeddings/audio_generation/chat_completion) (Required)
     *     model_provider_name: String (Required)
     * }
     * }
     * </pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return represents some basic information about the AI model along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponse(requestOptions);
    }

    /**
     * Returns information about the AI model.
     * The method makes a REST API call to the `/info` route on the given endpoint.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents some basic information about the AI model.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    ModelInfo getModelInfo() {
        // Generated convenience method for getModelInfoWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getModelInfoWithResponse(requestOptions).getValue().toObject(ModelInfo.class);
    }

    /**
     * Return the embedding vectors for given images.
     * The method makes a REST API call to the `/images/embeddings` route on the given endpoint.
     *
     * @param body request options to pass to the endpoint using images embeddings path.
     * @param extraParams Controls what happens if extra parameters, undefined by the REST API,
     * are passed in the JSON request payload.
     * This sets the HTTP request header `extra-parameters`.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    EmbeddingsResult embed(ImageEmbedRequest body, ExtraParameters extraParams) {
        // Generated convenience method for embedWithResponse
        RequestOptions requestOptions = new RequestOptions();
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString("extra-parameters"), extraParams.toString());
        }
        return embedWithResponse(BinaryData.fromObject(body), requestOptions).getValue()
            .toObject(EmbeddingsResult.class);
    }

    /**
     * Return the embedding vectors for given images.
     * The method makes a REST API call to the `/images/embeddings` route on the given endpoint.
     *
     * @param body request options to pass to the endpoint using images embeddings path.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    EmbeddingsResult embed(ImageEmbedRequest body) {
        // Generated convenience method for embedWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return embedWithResponse(BinaryData.fromObject(body), requestOptions).getValue()
            .toObject(EmbeddingsResult.class);
    }
}
