/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class ThrowableTypeAdapter
extends TypeAdapter<Throwable> {
    public Throwable read(JsonReader reader) {
        return new UnsupportedOperationException();
    }

    public void write(JsonWriter out, Throwable value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("type");
        out.value(value.getClass().getSimpleName());
        out.name("message");
        out.value(value.getMessage());
        Throwable cause = value.getCause();
        if (cause != null) {
            out.name("cause");
            this.write(out, cause);
        }
        out.endObject();
    }
}

