/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.node;

import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.ArrayNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.BinaryNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.BooleanNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.DecimalNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.DoubleNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.IntNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.LongNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.NullNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.NumericNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.ObjectNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.POJONode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.TextNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory {
    public static final JsonNodeFactory instance = new JsonNodeFactory();

    protected JsonNodeFactory() {
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Byte value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.intValue());
    }

    public NumericNode numberNode(short v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.shortValue());
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Integer value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public ValueNode numberNode(Long value) {
        return value == null ? this.nullNode() : LongNode.valueOf(value);
    }

    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    public NumericNode numberNode(float v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Float value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value.doubleValue());
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Double value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(v);
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }
}

