/*
 * Decompiled with CFR 0.152.
 */
package com.attunity.avro.decoder;

import com.attunity.avro.decoder.AttunityDecoderExceptionCode;

public class AttunityDecoderException
extends Exception {
    private AttunityDecoderExceptionCode errorCode;
    private String errorMessage;

    public AttunityDecoderExceptionCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AttunityDecoderException(AttunityDecoderExceptionCode code) {
        this.fillExceptionDetails(code, null);
    }

    public AttunityDecoderException(AttunityDecoderExceptionCode code, String schemaId) {
        this.fillExceptionDetails(code, schemaId);
    }

    private void fillExceptionDetails(AttunityDecoderExceptionCode code, String schemaId) {
        this.errorCode = code;
        switch (this.errorCode) {
            case BAD_INPUT_MESSAGE: {
                this.errorMessage = "Input message could not be parsed. Probably not a valid Attunity avro message";
                break;
            }
            case BAD_MAGIC_VALUE: {
                this.errorMessage = "Attunity message seems to be compromised. Magic field value is not as expected";
                break;
            }
            case BAD_METADATA_MESSAGE: {
                this.errorMessage = "Could not extract metadata message from enveloped message";
                break;
            }
            case BAD_DATA_MESSAGE: {
                this.errorMessage = "Could not extract data message from enveloped message using the provided schema";
                break;
            }
            case NO_METADATA_STORE_DEFINED: {
                this.errorMessage = String.format("Metadata store was not defined. Cannot load/save metadata for data message with schema id %s", schemaId);
                break;
            }
            case NO_METADATA_FOUND_IN_METADATA_STORE: {
                this.errorMessage = String.format("The data message cannot be opened as the metadata store failed to load Schema ID %s.", schemaId);
                break;
            }
            case UNRECOGNIZED_MESSAGE: {
                this.errorMessage = "Input message contains an unrecognized message type";
                break;
            }
            case FAILED_TO_SAVE_INTO_METADATA_STORE: {
                this.errorMessage = String.format("The metadata store failed to save bytes for Schema ID %s.", schemaId);
                break;
            }
            case FAILED_TO_LOAD_FROM_METADATA_STORE: {
                this.errorMessage = String.format("The metadata store failed to load bytes for Schema ID %s.", schemaId);
                break;
            }
            default: {
                this.errorMessage = "Unrecognized error code";
            }
        }
    }
}

