/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.imp.thread.ExecutorFactory;
import com.atomikos.icatch.imp.thread.InternalSystemExecutor;
import com.atomikos.icatch.imp.thread.Java14BackportExecutorFactory;
import com.atomikos.icatch.imp.thread.Java15ExecutorFactory;
import com.atomikos.icatch.imp.thread.TrivialExecutorFactory;
import com.atomikos.icatch.imp.thread.TrivialSystemExecutor;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.util.ClassLoadingHelper;

public class TaskManager {
    private static TaskManager singleton;
    private InternalSystemExecutor executor;

    public static final synchronized TaskManager getInstance() {
        if (singleton == null) {
            Configuration.logDebug("TaskManager: initializing...");
            singleton = new TaskManager();
        }
        return singleton;
    }

    protected TaskManager() {
        this.init();
    }

    private void init() {
        ExecutorFactory creator;
        try {
            if (this.isClassAvailable("java.util.concurrent.ThreadPoolExecutor")) {
                Configuration.logInfo("THREADS: using JDK thread pooling...");
                creator = new Java15ExecutorFactory();
            } else if (this.isClassAvailable("edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor")) {
                Configuration.logInfo("THREADS: using 1.4 (backport) thread pooling...");
                creator = new Java14BackportExecutorFactory();
            } else {
                Configuration.logWarning("THREADS: pooling NOT enabled!");
                creator = new TrivialExecutorFactory();
            }
        }
        catch (Exception e) {
            Configuration.logWarning("THREADS: Illegal setup, thread pooling is NOT enabled!", e);
            creator = new TrivialExecutorFactory();
        }
        try {
            this.executor = creator.createExecutor();
        }
        catch (Exception e) {
            Configuration.logWarning("Failed to create system executor; Received message: " + e.getMessage() + "; Failling back to a trivial executor.", e);
            this.executor = new TrivialSystemExecutor();
        }
        Configuration.logDebug("THREADS: using executor " + this.executor.getClass());
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public void executeTask(Runnable task) {
        if (this.executor == null) {
            this.init();
        }
        this.executor.execute(task);
    }

    private boolean isClassAvailable(String clazz) {
        try {
            ClassLoadingHelper.loadClass((String)clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

