/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CoordinatorImp;
import java.util.Map;

public class SubTransactionCoordinatorParticipant
implements Participant {
    private transient Participant subordinateCoordinator;
    private String subordinateId;
    private boolean prepareCalled;

    public SubTransactionCoordinatorParticipant(CoordinatorImp subordinateCoordinator) {
        this.subordinateCoordinator = subordinateCoordinator;
        this.subordinateId = subordinateCoordinator.getCoordinatorId();
        this.prepareCalled = false;
    }

    @Override
    public String getURI() {
        return this.subordinateId;
    }

    @Override
    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
        this.subordinateCoordinator.setCascadeList(allParticipants);
    }

    @Override
    public void setGlobalSiblingCount(int count) {
        this.subordinateCoordinator.setGlobalSiblingCount(count);
    }

    @Override
    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        this.prepareCalled = true;
        return this.subordinateCoordinator.prepare();
    }

    @Override
    public void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (this.subordinateCoordinator == null) {
            if (this.prepareCalled) {
                throw new HeurHazardException();
            }
            throw new RollbackException();
        }
        this.subordinateCoordinator.commit(onePhase);
    }

    @Override
    public void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.rollback();
        } else if (this.prepareCalled) {
            throw new HeurHazardException();
        }
    }

    @Override
    public void forget() {
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.forget();
        }
    }

    @Override
    public String getResourceName() {
        return null;
    }
}

