/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Iterator;

public class ConnectionPoolWithConcurrentValidation
extends ConnectionPool {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConnectionPoolWithConcurrentValidation.class);

    public ConnectionPoolWithConcurrentValidation(ConnectionFactory connectionFactory, ConnectionPoolProperties properties) throws ConnectionPoolException {
        super(connectionFactory, properties);
    }

    @Override
    protected Reapable recycleConnectionIfPossible() throws Exception {
        Reapable ret = null;
        XPooledConnection xpc = this.findFirstRecyclablePooledConnectionForCallingThread();
        if (xpc != null) {
            ret = this.concurrentlyTryToRecycle(xpc);
        }
        return ret;
    }

    @Override
    protected Reapable retrieveFirstAvailableConnection() {
        Reapable ret = null;
        XPooledConnection xpc = this.claimFirstAvailablePooledConnection();
        if (xpc != null) {
            ret = this.concurrentlyTryToUse(xpc);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reapable concurrentlyTryToRecycle(XPooledConnection xpc) throws Exception {
        Reapable ret = null;
        XPooledConnection xPooledConnection = xpc;
        synchronized (xPooledConnection) {
            if (xpc.canBeRecycledForCallingThread()) {
                ret = xpc.createConnectionProxy();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reapable concurrentlyTryToUse(XPooledConnection xpc) {
        Reapable ret = null;
        try {
            ret = xpc.createConnectionProxy();
        }
        catch (CreateConnectionException ex) {
            String msg = this + ": error creating proxy of connection " + xpc;
            LOGGER.logDebug(msg, (Throwable)ex);
            this.removePooledConnection(xpc);
        }
        finally {
            this.logCurrentPoolSize();
        }
        return ret;
    }

    private synchronized XPooledConnection claimFirstAvailablePooledConnection() {
        XPooledConnection ret = null;
        Iterator it = this.connections.iterator();
        while (it.hasNext() && ret == null) {
            XPooledConnection xpc = (XPooledConnection)it.next();
            if (!xpc.markAsBeingAcquiredIfAvailable()) continue;
            ret = xpc;
        }
        return ret;
    }

    private synchronized XPooledConnection findFirstRecyclablePooledConnectionForCallingThread() {
        XPooledConnection ret = null;
        Iterator it = this.connections.iterator();
        while (it.hasNext() && ret == null) {
            XPooledConnection xpc = (XPooledConnection)it.next();
            if (!xpc.canBeRecycledForCallingThread()) continue;
            ret = xpc;
        }
        return ret;
    }

    private synchronized void removePooledConnection(XPooledConnection xpc) {
        this.connections.remove(xpc);
        this.destroyPooledConnection(xpc);
    }
}

