/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class SiblingMapper {
    protected Hashtable siblings_ = new Hashtable();
    protected XATransactionalResource res_;
    protected String root_;

    SiblingMapper(XATransactionalResource res, String root) {
        this.res_ = res;
        this.root_ = root;
    }

    protected ResourceTransaction map(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        Stack<Exception> errors = new Stack<Exception>();
        XAResourceTransaction last = null;
        try {
            last = (XAResourceTransaction)this.siblings_.get(ct);
            if (last == null || this.res_.usesWeakCompare() || this.res_.acceptsAllXAResources() || last.isActive()) {
                Enumeration enumm = this.siblings_.elements();
                if (enumm.hasMoreElements()) {
                    last = (XAResourceTransaction)enumm.nextElement();
                }
                if (last == null || !ct.isSerial() || this.res_.usesWeakCompare() || this.res_.acceptsAllXAResources() || last.isActive()) {
                    last = new XAResourceTransaction(this.res_, ct, this.root_);
                    this.siblings_.put(ct, last);
                }
            }
        }
        catch (Exception e) {
            errors.push(e);
            throw new ResourceException("ResourceTransaction map failure", errors);
        }
        ct.addParticipant((Participant)last);
        return last;
    }
}

