/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.ClassNotPrimitiveException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public final class PrimitiveClasses {
    private static Map map_ = new HashMap();
    private static Map numericMap_ = new HashMap();

    public static boolean isNumericClass(Class clazz) {
        return numericMap_.containsKey(clazz);
    }

    public static boolean isDecimalClass(Class clazz) {
        boolean ret = false;
        Boolean value = (Boolean)numericMap_.get(clazz);
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Class getWrapperClass(Class primitiveClass) {
        return (Class)map_.get(primitiveClass);
    }

    public static Object createWrapperObject(String val, Class primitiveClass) throws ClassNotPrimitiveException {
        Object ret = null;
        Class[] args = new Class[]{String.class};
        Class wrapperClass = PrimitiveClasses.getWrapperClass(primitiveClass);
        if (wrapperClass == null) {
            throw new ClassNotPrimitiveException(primitiveClass.getName());
        }
        try {
            Constructor c = wrapperClass.getConstructor(args);
            Object[] initArgs = new Object[]{val};
            if (c != null) {
                ret = c.newInstance(initArgs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return ret;
    }

    static {
        map_.put(Boolean.TYPE, Boolean.class);
        map_.put(Character.TYPE, Character.class);
        map_.put(Short.TYPE, Short.class);
        map_.put(Integer.TYPE, Integer.class);
        map_.put(Long.TYPE, Long.class);
        map_.put(Float.TYPE, Float.class);
        map_.put(Double.TYPE, Double.class);
        map_.put(Byte.TYPE, Byte.class);
        map_.put(Void.TYPE, Void.class);
        numericMap_.put(Short.class, new Boolean(false));
        numericMap_.put(Integer.class, new Boolean(false));
        numericMap_.put(Long.class, new Boolean(false));
        numericMap_.put(Float.class, new Boolean(true));
        numericMap_.put(Double.class, new Boolean(true));
    }
}

