/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.restassured;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import io.restassured.specification.FilterableRequestSpecification;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAssuredRequest
implements Request {
    private static final Logger log = LoggerFactory.getLogger(RestAssuredRequest.class);
    private final Request delegate;

    @Deprecated
    public RestAssuredRequest(@Nonnull FilterableRequestSpecification originalRequest) {
        this.delegate = RestAssuredRequest.of(originalRequest);
    }

    @Nonnull
    public String getPath() {
        return this.delegate.getPath();
    }

    @Nonnull
    public Request.Method getMethod() {
        return this.delegate.getMethod();
    }

    @Nonnull
    public Optional<String> getBody() {
        return this.delegate.getBody();
    }

    @Nonnull
    public Collection<String> getQueryParameters() {
        return this.delegate.getQueryParameters();
    }

    @Nonnull
    public Collection<String> getQueryParameterValues(String name) {
        return this.delegate.getQueryParameterValues(name);
    }

    @Nonnull
    public Map<String, Collection<String>> getHeaders() {
        return this.delegate.getHeaders();
    }

    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        return this.delegate.getHeaderValues(name);
    }

    @Nonnull
    public static Request of(@Nonnull FilterableRequestSpecification originalRequest) {
        Objects.requireNonNull(originalRequest, "An original request is required");
        SimpleRequest.Builder builder = new SimpleRequest.Builder(originalRequest.getMethod(), originalRequest.getDerivedPath());
        RestAssuredRequest.setBody(builder, originalRequest);
        if (originalRequest.getHeaders() != null) {
            originalRequest.getHeaders().forEach(header -> builder.withHeader(header.getName(), new String[]{header.getValue()}));
        }
        if (originalRequest.getContentType() != null) {
            builder.withContentType(originalRequest.getContentType());
        }
        new HashMap<String, Object>(originalRequest.getQueryParams()).forEach((key, value) -> {
            if (value instanceof List) {
                builder.withQueryParam(key, (List)value);
            } else if (value instanceof String) {
                builder.withQueryParam(key, new String[]{(String)value});
            }
        });
        if ("GET".equalsIgnoreCase(originalRequest.getMethod())) {
            originalRequest.getRequestParams().forEach((x$0, xva$1) -> builder.withQueryParam(x$0, new String[]{xva$1}));
        }
        return builder.build();
    }

    private static void setBody(SimpleRequest.Builder builder, FilterableRequestSpecification originalRequest) {
        Object body = originalRequest.getBody();
        if (body == null) {
            return;
        }
        if (body instanceof String) {
            builder.withBody((String)body);
        } else if (body instanceof byte[]) {
            builder.withBody((byte[])body);
        } else if (body instanceof InputStream) {
            builder.withBody((InputStream)body);
        } else {
            log.warn("Only String, byte[] and InputStream bodies supported. No request body of type '{}' will be used in validation.", body.getClass());
        }
    }
}

