/**
 * A Japanese morphological analyzer based on the IPADIC dictionary.
 * <p>
 * This dictionary provides a basic set of features and suits many tasks.
 * If you are not sure about which dictionary to use, this one is a good starting point.
 * <p>
 * The following token features are supported:
 * <ul>
 * <li>surface form (表層形)
 * <li>part of speech level 1 (品詞細分類1)
 * <li>part of speech level 2 (品詞細分類2)
 * <li>part of speech level 3 (品詞細分類3)
 * <li>part of speech level 4 (品詞細分類4)
 * <li>conjugation type (活用型)
 * <li>conjugation form (活用形)
 * <li>base form (基本形)
 * <li>reading (読み)
 * <li>pronunciation (発音)
 * </ul>
 */
package com.atilika.kuromoji.ipadic;
