/*
 * DISCLAIMER
 *
 * Copyright 2018 ArangoDB GmbH, Cologne, Germany
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright holder is ArangoDB GmbH, Cologne, Germany
 */

package com.arangodb;

import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;

import javax.annotation.concurrent.ThreadSafe;

/**
 * Interface for operations on ArangoDB view level for ArangoSearch views.
 *
 * @author Mark Vollmary
 * @see <a href="https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/">View API Documentation</a>
 * @since ArangoDB 3.4.0
 */
@ThreadSafe
public interface ArangoSearch extends ArangoView {

    /**
     * Creates a view, then returns view information from the server.
     *
     * @return information about the view
     * @see <a href="https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/#create-an-arangosearch-view">API
     * Documentation</a>
     */
    ViewEntity create();

    /**
     * Creates a view with the given {@code options}, then returns view information from the server.
     *
     * @param options Additional options, can be null
     * @return information about the view
     * @see <a href="https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/#create-an-arangosearch-view">API
     * Documentation</a>
     */
    ViewEntity create(ArangoSearchCreateOptions options);

    /**
     * Reads the properties of the specified view.
     *
     * @return properties of the view
     * @see <a href="https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/#get-the-properties-of-a-view">API
     * Documentation</a>
     */
    ArangoSearchPropertiesEntity getProperties();

    /**
     * Partially changes properties of the view.
     *
     * @param options properties to change
     * @return properties of the view
     * @see <a href=
     * "https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/#update-the-properties-of-an-arangosearch-view">API
     * Documentation</a>
     */
    ArangoSearchPropertiesEntity updateProperties(ArangoSearchPropertiesOptions options);

    /**
     * Changes properties of the view.
     *
     * @param options properties to change
     * @return properties of the view
     * @see <a href=
     * "https://docs.arangodb.com/stable/develop/http-api/views/arangosearch-views/#replace-the-properties-of-an-arangosearch-view">API
     * Documentation</a>
     */
    ArangoSearchPropertiesEntity replaceProperties(ArangoSearchPropertiesOptions options);

}
