/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.internal.serde.UserDataInside;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class AqlQueryOptions
implements Cloneable {
    private Boolean count;
    private Integer ttl;
    private Integer batchSize;
    private Boolean cache;
    private Long memoryLimit;
    private Map<String, Object> bindVars;
    private String query;
    private Options options;
    private Boolean allowDirtyRead;
    private String streamTransactionId;

    public Boolean getCount() {
        return this.count;
    }

    public AqlQueryOptions count(Boolean count) {
        this.count = count;
        return this;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public AqlQueryOptions ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AqlQueryOptions batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Long getMemoryLimit() {
        return this.memoryLimit;
    }

    public AqlQueryOptions memoryLimit(Long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public AqlQueryOptions cache(Boolean cache) {
        this.cache = cache;
        return this;
    }

    public Boolean getFillBlockCache() {
        return this.getOptions().fillBlockCache;
    }

    public AqlQueryOptions fillBlockCache(Boolean fillBlockCache) {
        this.getOptions().fillBlockCache = fillBlockCache;
        return this;
    }

    @UserDataInside
    public Map<String, Object> getBindVars() {
        return this.bindVars;
    }

    AqlQueryOptions bindVars(Map<String, Object> bindVarsBytes) {
        this.bindVars = bindVarsBytes;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public AqlQueryOptions query(String query) {
        this.query = query;
        return this;
    }

    public Boolean getFailOnWarning() {
        return this.getOptions().failOnWarning;
    }

    public AqlQueryOptions failOnWarning(Boolean failOnWarning) {
        this.getOptions().failOnWarning = failOnWarning;
        return this;
    }

    public AqlQueryOptions maxRuntime(Double timeout) {
        this.getOptions().maxRuntime = timeout;
        return this;
    }

    public Boolean getProfile() {
        return this.getOptions().profile;
    }

    public AqlQueryOptions profile(Boolean profile) {
        this.getOptions().profile = profile;
        return this;
    }

    public Long getMaxTransactionSize() {
        return this.getOptions().maxTransactionSize;
    }

    public AqlQueryOptions maxTransactionSize(Long maxTransactionSize) {
        this.getOptions().maxTransactionSize = maxTransactionSize;
        return this;
    }

    public Long getMaxWarningCount() {
        return this.getOptions().maxWarningCount;
    }

    public AqlQueryOptions maxWarningCount(Long maxWarningCount) {
        this.getOptions().maxWarningCount = maxWarningCount;
        return this;
    }

    public Long getIntermediateCommitCount() {
        return this.getOptions().intermediateCommitCount;
    }

    public AqlQueryOptions intermediateCommitCount(Long intermediateCommitCount) {
        this.getOptions().intermediateCommitCount = intermediateCommitCount;
        return this;
    }

    public Long getIntermediateCommitSize() {
        return this.getOptions().intermediateCommitSize;
    }

    public AqlQueryOptions intermediateCommitSize(Long intermediateCommitSize) {
        this.getOptions().intermediateCommitSize = intermediateCommitSize;
        return this;
    }

    public Double getSatelliteSyncWait() {
        return this.getOptions().satelliteSyncWait;
    }

    public AqlQueryOptions satelliteSyncWait(Double satelliteSyncWait) {
        this.getOptions().satelliteSyncWait = satelliteSyncWait;
        return this;
    }

    public Boolean getSkipInaccessibleCollections() {
        return this.getOptions().skipInaccessibleCollections;
    }

    public AqlQueryOptions skipInaccessibleCollections(Boolean skipInaccessibleCollections) {
        this.getOptions().skipInaccessibleCollections = skipInaccessibleCollections;
        return this;
    }

    public Boolean getFullCount() {
        return this.getOptions().fullCount;
    }

    public AqlQueryOptions fullCount(Boolean fullCount) {
        this.getOptions().fullCount = fullCount;
        return this;
    }

    public Integer getMaxPlans() {
        return this.getOptions().maxPlans;
    }

    public AqlQueryOptions maxPlans(Integer maxPlans) {
        this.getOptions().maxPlans = maxPlans;
        return this;
    }

    public Collection<String> getRules() {
        return this.getOptions().getOptimizer().rules;
    }

    public AqlQueryOptions rules(Collection<String> rules) {
        this.getOptions().getOptimizer().rules = rules;
        return this;
    }

    public Boolean getStream() {
        return this.getOptions().stream;
    }

    public AqlQueryOptions stream(Boolean stream) {
        this.getOptions().stream = stream;
        return this;
    }

    public Collection<String> getShardIds() {
        return this.getOptions().shardIds;
    }

    public AqlQueryOptions shardIds(String ... shardIds) {
        this.getOptions().shardIds = Arrays.asList(shardIds);
        return this;
    }

    public String getForceOneShardAttributeValue() {
        return this.options != null ? this.options.forceOneShardAttributeValue : null;
    }

    public AqlQueryOptions forceOneShardAttributeValue(String forceOneShardAttributeValue) {
        this.getOptions().forceOneShardAttributeValue = forceOneShardAttributeValue;
        return this;
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public AqlQueryOptions allowDirtyRead(Boolean allowDirtyRead) {
        this.allowDirtyRead = allowDirtyRead;
        return this;
    }

    public Boolean getAllowDirtyRead() {
        return this.allowDirtyRead;
    }

    public String getStreamTransactionId() {
        return this.streamTransactionId;
    }

    public AqlQueryOptions streamTransactionId(String streamTransactionId) {
        this.streamTransactionId = streamTransactionId;
        return this;
    }

    public Boolean getAllowRetry() {
        return this.getOptions().allowRetry;
    }

    public AqlQueryOptions allowRetry(Boolean allowRetry) {
        this.getOptions().allowRetry = allowRetry;
        return this;
    }

    public AqlQueryOptions clone() {
        try {
            AqlQueryOptions clone = (AqlQueryOptions)super.clone();
            clone.bindVars = this.bindVars != null ? new HashMap<String, Object>(this.bindVars) : null;
            clone.options = this.options != null ? this.options.clone() : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static final class Optimizer
    implements Cloneable {
        private Collection<String> rules;

        public Collection<String> getRules() {
            return this.rules;
        }

        public Optimizer clone() {
            try {
                Optimizer clone = (Optimizer)super.clone();
                clone.rules = this.rules != null ? new ArrayList<String>(this.rules) : null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    public static final class Options
    implements Cloneable {
        private Boolean failOnWarning;
        private Boolean profile;
        private Long maxTransactionSize;
        private Long maxWarningCount;
        private Long intermediateCommitCount;
        private Long intermediateCommitSize;
        private Double satelliteSyncWait;
        private Boolean skipInaccessibleCollections;
        private Optimizer optimizer;
        private Boolean fullCount;
        private Integer maxPlans;
        private Boolean stream;
        private Collection<String> shardIds;
        private Double maxRuntime;
        private Boolean fillBlockCache;
        private String forceOneShardAttributeValue;
        private Boolean allowRetry;

        public Boolean getFailOnWarning() {
            return this.failOnWarning;
        }

        public Boolean getProfile() {
            return this.profile;
        }

        public Long getMaxTransactionSize() {
            return this.maxTransactionSize;
        }

        public Long getMaxWarningCount() {
            return this.maxWarningCount;
        }

        public Long getIntermediateCommitCount() {
            return this.intermediateCommitCount;
        }

        public Long getIntermediateCommitSize() {
            return this.intermediateCommitSize;
        }

        public Double getSatelliteSyncWait() {
            return this.satelliteSyncWait;
        }

        public Boolean getSkipInaccessibleCollections() {
            return this.skipInaccessibleCollections;
        }

        public Boolean getFullCount() {
            return this.fullCount;
        }

        public Integer getMaxPlans() {
            return this.maxPlans;
        }

        public Boolean getStream() {
            return this.stream;
        }

        public Double getMaxRuntime() {
            return this.maxRuntime;
        }

        public Boolean getFillBlockCache() {
            return this.fillBlockCache;
        }

        public String getForceOneShardAttributeValue() {
            return this.forceOneShardAttributeValue;
        }

        public Optimizer getOptimizer() {
            if (this.optimizer == null) {
                this.optimizer = new Optimizer();
            }
            return this.optimizer;
        }

        public Collection<String> getShardIds() {
            return this.shardIds;
        }

        public Boolean getAllowRetry() {
            return this.allowRetry;
        }

        public Options clone() {
            try {
                Options clone = (Options)super.clone();
                clone.optimizer = this.optimizer != null ? this.optimizer.clone() : null;
                clone.shardIds = this.shardIds != null ? new ArrayList<String>(this.shardIds) : null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

