/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.ArangoDBException;
import java.util.regex.Pattern;

public final class DocumentUtil {
    public static final String REGEX_KEY = "[^/]+";
    public static final String REGEX_ID = "[^/]+/[^/]+";
    private static final String SLASH = "/";

    private DocumentUtil() {
    }

    public static void validateIndexId(String id) {
        DocumentUtil.validateName("index id", REGEX_ID, id);
    }

    public static void validateDocumentKey(String key) {
        DocumentUtil.validateName("document key", REGEX_KEY, key);
    }

    public static void validateDocumentId(String id) {
        DocumentUtil.validateName("document id", REGEX_ID, id);
    }

    public static String createDocumentHandle(String collection, String key) {
        DocumentUtil.validateDocumentKey(key);
        return collection + SLASH + key;
    }

    private static void validateName(String type, String regex, CharSequence name) {
        if (!Pattern.matches(regex, name)) {
            throw new ArangoDBException(String.format("%s %s is not valid.", type, name));
        }
    }
}

