/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.SearchAliasAsync;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.SearchAliasPropertiesEntity;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalSearchAlias;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasPropertiesOptions;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class SearchAliasAsyncImpl
extends InternalSearchAlias
implements SearchAliasAsync {
    private final ArangoDatabaseAsync db;

    protected SearchAliasAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db;
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<Void> drop() {
        return this.executorAsync().execute(this::dropRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<ViewEntity> rename(String newName) {
        return this.executorAsync().execute(() -> this.renameRequest(newName), (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> getInfo() {
        return this.executorAsync().execute(this::getInfoRequest, (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> create() {
        return this.create(new SearchAliasCreateOptions());
    }

    @Override
    public CompletableFuture<ViewEntity> create(SearchAliasCreateOptions options) {
        return this.db().createSearchAlias(this.name(), options);
    }

    @Override
    public CompletableFuture<SearchAliasPropertiesEntity> getProperties() {
        return this.executorAsync().execute(this::getPropertiesRequest, (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<SearchAliasPropertiesEntity> updateProperties(SearchAliasPropertiesOptions options) {
        return this.executorAsync().execute(() -> this.updatePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<SearchAliasPropertiesEntity> replaceProperties(SearchAliasPropertiesOptions options) {
        return this.executorAsync().execute(() -> this.replacePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }
}

