/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.arch.UsedInApi;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.ArangoDBUnavailableException;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.internal.util.ResponseUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsedInApi
public abstract class Communication
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Communication.class);
    protected final HostHandler hostHandler;
    protected final InternalSerde serde;
    private final AtomicLong reqCount;

    protected Communication(ArangoConfig config, HostHandler hostHandler) {
        this.hostHandler = hostHandler;
        this.serde = config.getInternalSerde();
        this.reqCount = new AtomicLong();
    }

    protected abstract void connect(Connection var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.hostHandler.close();
    }

    public CompletableFuture<InternalResponse> executeAsync(InternalRequest request, HostHandle hostHandle) {
        return this.executeAsync(request, hostHandle, this.hostHandler.get(hostHandle, RequestUtils.determineAccessType(request)), 0);
    }

    private CompletableFuture<InternalResponse> executeAsync(InternalRequest request, HostHandle hostHandle, Host host, int attemptCount) {
        long reqId = this.reqCount.getAndIncrement();
        return this.doExecuteAsync(request, hostHandle, host, attemptCount, host.connection(), reqId);
    }

    private CompletableFuture<InternalResponse> doExecuteAsync(InternalRequest request, HostHandle hostHandle, Host host, int attemptCount, Connection connection, long reqId) {
        if (LOGGER.isDebugEnabled()) {
            String body = request.getBody() == null ? "" : this.serde.toJsonString(request.getBody());
            LOGGER.debug("Send Request [id={}]: {} {}", new Object[]{reqId, request, body});
        }
        CompletableFuture<InternalResponse> rfuture = new CompletableFuture<InternalResponse>();
        try {
            this.connect(connection);
        }
        catch (IOException e2) {
            this.handleException(true, e2, hostHandle, request, host, reqId, attemptCount, rfuture);
            return rfuture;
        }
        connection.executeAsync(request).whenComplete((response, e) -> {
            try {
                if (e instanceof SocketTimeoutException) {
                    TimeoutException te = new TimeoutException(e.getMessage());
                    te.initCause((Throwable)e);
                    rfuture.completeExceptionally(ArangoDBException.of(te, reqId));
                } else if (e instanceof TimeoutException) {
                    rfuture.completeExceptionally(ArangoDBException.of(e, reqId));
                } else if (e instanceof ConnectException) {
                    this.handleException(true, (Throwable)e, hostHandle, request, host, reqId, attemptCount, rfuture);
                } else if (e != null) {
                    this.handleException(this.isSafe(request), (Throwable)e, hostHandle, request, host, reqId, attemptCount, rfuture);
                } else {
                    ArangoDBException errorEntityEx;
                    if (LOGGER.isDebugEnabled()) {
                        String body = response.getBody() == null ? "" : this.serde.toJsonString(response.getBody());
                        LOGGER.debug("Received Response [id={}]: {} {}", new Object[]{reqId, response, body});
                    }
                    if ((errorEntityEx = ResponseUtils.translateError(this.serde, response)) instanceof ArangoDBRedirectException) {
                        if (attemptCount >= 3) {
                            rfuture.completeExceptionally(errorEntityEx);
                        } else {
                            String location = ((ArangoDBRedirectException)errorEntityEx).getLocation();
                            HostDescription redirectHost = HostUtils.createFromLocation(location);
                            this.hostHandler.failIfNotMatch(redirectHost, errorEntityEx);
                            this.mirror(this.executeAsync(request, new HostHandle().setHost(redirectHost), this.hostHandler.get(hostHandle, RequestUtils.determineAccessType(request)), attemptCount + 1), rfuture);
                        }
                    } else if (errorEntityEx instanceof ArangoDBUnavailableException) {
                        this.handleException(true, errorEntityEx, hostHandle, request, host, reqId, attemptCount, rfuture);
                    } else if (errorEntityEx != null) {
                        rfuture.completeExceptionally(errorEntityEx);
                    } else {
                        this.hostHandler.success();
                        rfuture.complete((InternalResponse)response);
                    }
                }
            }
            catch (Exception ex) {
                rfuture.completeExceptionally(ArangoDBException.of(ex, reqId));
            }
        });
        return rfuture;
    }

    private void handleException(boolean isSafe, Throwable e, HostHandle hostHandle, InternalRequest request, Host host, long reqId, int attemptCount, CompletableFuture<InternalResponse> rfuture) {
        IOException ioEx = Communication.wrapIOEx(e);
        this.hostHandler.fail(ioEx);
        if (hostHandle != null && hostHandle.getHost() != null) {
            hostHandle.setHost(null);
        }
        this.hostHandler.checkNext(hostHandle, RequestUtils.determineAccessType(request));
        if (isSafe) {
            Host nextHost = this.hostHandler.get(hostHandle, RequestUtils.determineAccessType(request));
            LOGGER.warn("Could not connect to {} while executing request [id={}]", new Object[]{host.getDescription(), reqId, ioEx});
            LOGGER.debug("Try connecting to {}", (Object)nextHost.getDescription());
            this.mirror(this.executeAsync(request, hostHandle, nextHost, attemptCount), rfuture);
        } else {
            ArangoDBException aEx = ArangoDBException.of(ioEx, reqId);
            rfuture.completeExceptionally(aEx);
        }
    }

    private void mirror(CompletableFuture<InternalResponse> up, CompletableFuture<InternalResponse> down) {
        up.whenComplete((v, err) -> {
            if (err != null) {
                down.completeExceptionally(err instanceof CompletionException ? err.getCause() : err);
            } else {
                down.complete((InternalResponse)v);
            }
        });
    }

    private static IOException wrapIOEx(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    private boolean isSafe(InternalRequest request) {
        RequestType type = request.getRequestType();
        return type == RequestType.GET || type == RequestType.HEAD || type == RequestType.OPTIONS;
    }
}

