/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.IndexType;
import com.arangodb.model.IndexOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class PersistentIndexOptions
extends IndexOptions<PersistentIndexOptions> {
    private final IndexType type = IndexType.persistent;
    private Iterable<String> fields;
    private Boolean unique;
    private Boolean sparse;
    private Boolean deduplicate;
    private Boolean estimates;
    private Boolean cacheEnabled;
    private Collection<String> storedValues;

    @Override
    PersistentIndexOptions getThis() {
        return this;
    }

    public Iterable<String> getFields() {
        return this.fields;
    }

    PersistentIndexOptions fields(Iterable<String> fields) {
        this.fields = fields;
        return this;
    }

    public IndexType getType() {
        return this.type;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public PersistentIndexOptions unique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    public Boolean getSparse() {
        return this.sparse;
    }

    public PersistentIndexOptions sparse(Boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Boolean getDeduplicate() {
        return this.deduplicate;
    }

    public PersistentIndexOptions deduplicate(Boolean deduplicate) {
        this.deduplicate = deduplicate;
        return this;
    }

    public PersistentIndexOptions estimates(Boolean estimates) {
        this.estimates = estimates;
        return this;
    }

    public Boolean getEstimates() {
        return this.estimates;
    }

    public PersistentIndexOptions cacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    public Boolean getCacheEnabled() {
        return this.cacheEnabled;
    }

    public Collection<String> getStoredValues() {
        return this.storedValues;
    }

    public PersistentIndexOptions storedValues(String ... storedValues) {
        if (this.storedValues == null) {
            this.storedValues = new HashSet<String>();
        }
        Collections.addAll(this.storedValues, storedValues);
        return this;
    }
}

