/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoEdgeCollectionAsync;
import com.arangodb.ArangoGraphAsync;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphAsyncImpl;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.model.EdgeCollectionDropOptions;
import com.arangodb.model.EdgeCollectionRemoveOptions;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoEdgeCollectionAsyncImpl
extends InternalArangoEdgeCollection
implements ArangoEdgeCollectionAsync {
    private final ArangoGraphAsync graph;

    protected ArangoEdgeCollectionAsyncImpl(ArangoGraphAsyncImpl graph, String name) {
        super(graph, graph.db().name(), graph.name(), name);
        this.graph = graph;
    }

    @Override
    public ArangoGraphAsync graph() {
        return this.graph;
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> drop() {
        return this.drop(new EdgeCollectionDropOptions());
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> drop(EdgeCollectionDropOptions options) {
        return this.executorAsync().execute(() -> this.removeEdgeDefinitionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.remove(new EdgeCollectionRemoveOptions());
    }

    @Override
    public CompletableFuture<Void> remove(EdgeCollectionRemoveOptions options) {
        return this.executorAsync().execute(() -> this.removeEdgeDefinitionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<EdgeEntity> insertEdge(Object value) {
        return this.executorAsync().execute(() -> this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer());
    }

    @Override
    public CompletableFuture<EdgeEntity> insertEdge(Object value, EdgeCreateOptions options) {
        return this.executorAsync().execute(() -> this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer());
    }

    @Override
    public <T> CompletableFuture<T> getEdge(String key, Class<T> type) {
        return this.getEdge(key, type, null);
    }

    @Override
    public <T> CompletableFuture<T> getEdge(String key, Class<T> type, GraphDocumentReadOptions options) {
        return this.executorAsync().execute(() -> this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && (ArangoErrors.matches(aEx = (ArangoDBException)e, 304) || ArangoErrors.matches(aEx, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(aEx, 412, ArangoErrors.ERROR_ARANGO_CONFLICT))) {
                return null;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<EdgeUpdateEntity> replaceEdge(String key, Object value) {
        return this.executorAsync().execute(() -> this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public CompletableFuture<EdgeUpdateEntity> replaceEdge(String key, Object value, EdgeReplaceOptions options) {
        return this.executorAsync().execute(() -> this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public CompletableFuture<EdgeUpdateEntity> updateEdge(String key, Object value) {
        return this.executorAsync().execute(() -> this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer());
    }

    @Override
    public CompletableFuture<EdgeUpdateEntity> updateEdge(String key, Object value, EdgeUpdateOptions options) {
        return this.executorAsync().execute(() -> this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> deleteEdge(String key) {
        return this.executorAsync().execute(() -> this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteEdge(String key, EdgeDeleteOptions options) {
        return this.executorAsync().execute(() -> this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

