/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ViewType;
import com.arangodb.model.AbstractMDIndexOptions;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.AqlQueryParseOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionRenameOptions;
import com.arangodb.model.ExplainAqlQueryOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.VertexCollectionCreateOptions;
import com.arangodb.model.ViewCreateOptions;
import com.arangodb.model.ViewRenameOptions;
import com.arangodb.model.ZKDIndexOptions;
import java.util.ArrayList;
import java.util.Map;

public final class OptionsBuilder {
    private OptionsBuilder() {
    }

    public static UserCreateOptions build(UserCreateOptions options, String user, String passwd) {
        return options.user(user).passwd(passwd);
    }

    public static PersistentIndexOptions build(PersistentIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static GeoIndexOptions build(GeoIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    @Deprecated
    public static FulltextIndexOptions build(FulltextIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static TtlIndexOptions build(TtlIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static ZKDIndexOptions build(ZKDIndexOptions options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static AbstractMDIndexOptions<?> build(AbstractMDIndexOptions<?> options, Iterable<String> fields) {
        return options.fields(fields);
    }

    public static CollectionCreateOptions build(CollectionCreateOptions options, String name) {
        return options.name(name);
    }

    public static AqlQueryOptions build(AqlQueryOptions options, String query, Map<String, ?> bindVars) {
        return options.query(query).bindVars(bindVars);
    }

    public static AqlQueryExplainOptions build(AqlQueryExplainOptions options, String query, Map<String, ?> bindVars) {
        return options.query(query).bindVars(bindVars);
    }

    public static ExplainAqlQueryOptions build(ExplainAqlQueryOptions options, String query, Map<String, ?> bindVars) {
        return options.query(query).bindVars(bindVars);
    }

    public static AqlQueryParseOptions build(AqlQueryParseOptions options, String query) {
        return options.query(query);
    }

    public static GraphCreateOptions build(GraphCreateOptions options, String name, Iterable<EdgeDefinition> edgeDefinitions) {
        ArrayList<EdgeDefinition> edCol = new ArrayList<EdgeDefinition>();
        if (edgeDefinitions != null) {
            edgeDefinitions.forEach(edCol::add);
        }
        return options.name(name).edgeDefinitions(edCol);
    }

    public static TransactionOptions build(TransactionOptions options, String action) {
        return options.action(action);
    }

    public static CollectionRenameOptions build(CollectionRenameOptions options, String name) {
        return options.name(name);
    }

    public static UserAccessOptions build(UserAccessOptions options, Permissions grant) {
        return options.grant(grant);
    }

    public static AqlFunctionCreateOptions build(AqlFunctionCreateOptions options, String name, String code) {
        return options.name(name).code(code);
    }

    public static VertexCollectionCreateOptions build(VertexCollectionCreateOptions options, String collection) {
        return options.collection(collection);
    }

    public static ViewCreateOptions build(ViewCreateOptions options, String name, ViewType type) {
        return options.name(name).type(type);
    }

    public static ViewRenameOptions build(ViewRenameOptions options, String name) {
        return options.name(name);
    }
}

