/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.ReplicationFactor;
import java.util.Arrays;
import java.util.Collection;

public final class GraphCreateOptions {
    private String name;
    private Collection<EdgeDefinition> edgeDefinitions;
    private Collection<String> orphanCollections;
    private Boolean isSmart;
    private SmartOptions options;
    private Boolean waitForSync;

    public String getName() {
        return this.name;
    }

    GraphCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public Collection<EdgeDefinition> getEdgeDefinitions() {
        return this.edgeDefinitions;
    }

    GraphCreateOptions edgeDefinitions(Collection<EdgeDefinition> edgeDefinitions) {
        this.edgeDefinitions = edgeDefinitions;
        return this;
    }

    public Collection<String> getOrphanCollections() {
        return this.orphanCollections;
    }

    public GraphCreateOptions orphanCollections(String ... orphanCollections) {
        this.orphanCollections = Arrays.asList(orphanCollections);
        return this;
    }

    public Boolean getIsSmart() {
        return this.isSmart;
    }

    public GraphCreateOptions isSmart(Boolean isSmart) {
        this.isSmart = isSmart;
        return this;
    }

    public Boolean getIsDisjoint() {
        return this.getOptions().getIsDisjoint();
    }

    public GraphCreateOptions isDisjoint(Boolean isDisjoint) {
        this.getOptions().setIsDisjoint(isDisjoint);
        return this;
    }

    public ReplicationFactor getReplicationFactor() {
        return this.getOptions().replicationFactor;
    }

    public GraphCreateOptions replicationFactor(ReplicationFactor replicationFactor) {
        this.getOptions().setReplicationFactor(replicationFactor);
        return this;
    }

    public GraphCreateOptions replicationFactor(int replicationFactor) {
        this.getOptions().setReplicationFactor(ReplicationFactor.of(replicationFactor));
        return this;
    }

    public Integer getWriteConcern() {
        return this.getOptions().getWriteConcern();
    }

    public GraphCreateOptions writeConcern(Integer writeConcern) {
        this.getOptions().setWriteConcern(writeConcern);
        return this;
    }

    public Integer getNumberOfShards() {
        return this.getOptions().getNumberOfShards();
    }

    public GraphCreateOptions numberOfShards(Integer numberOfShards) {
        this.getOptions().setNumberOfShards(numberOfShards);
        return this;
    }

    public String getSmartGraphAttribute() {
        return this.getOptions().getSmartGraphAttribute();
    }

    public GraphCreateOptions smartGraphAttribute(String smartGraphAttribute) {
        this.getOptions().setSmartGraphAttribute(smartGraphAttribute);
        return this;
    }

    public Collection<String> getSatellites() {
        return this.getOptions().getSatellites();
    }

    public GraphCreateOptions satellites(String ... satellites) {
        this.getOptions().setSatellites(satellites);
        return this;
    }

    public Boolean getWaitForSync() {
        return this.waitForSync;
    }

    public GraphCreateOptions waitForSync(Boolean waitForSync) {
        this.waitForSync = waitForSync;
        return this;
    }

    public SmartOptions getOptions() {
        if (this.options == null) {
            this.options = new SmartOptions();
        }
        return this.options;
    }

    public static final class SmartOptions {
        private String smartGraphAttribute;
        private Collection<String> satellites;
        private Integer numberOfShards;
        private ReplicationFactor replicationFactor;
        private Integer writeConcern;
        private Boolean isDisjoint;

        public ReplicationFactor getReplicationFactor() {
            return this.replicationFactor;
        }

        public void setReplicationFactor(ReplicationFactor replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        public Integer getWriteConcern() {
            return this.writeConcern;
        }

        public void setWriteConcern(Integer writeConcern) {
            this.writeConcern = writeConcern;
        }

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public String getSmartGraphAttribute() {
            return this.smartGraphAttribute;
        }

        public void setSmartGraphAttribute(String smartGraphAttribute) {
            this.smartGraphAttribute = smartGraphAttribute;
        }

        public Boolean getIsDisjoint() {
            return this.isDisjoint;
        }

        public void setIsDisjoint(Boolean isDisjoint) {
            this.isDisjoint = isDisjoint;
        }

        public Collection<String> getSatellites() {
            return this.satellites;
        }

        public void setSatellites(String ... satellites) {
            this.satellites = Arrays.asList(satellites);
        }
    }
}

