/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.internal.serde.InternalParameterizedType;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SerdeUtils {
    INSTANCE;

    private static final Logger LOGGER;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public static Type constructListType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructCollectionType(List.class, clazz);
    }

    public static Type constructParametricType(Class<?> rawType, Type ... rawArgs) {
        if (rawArgs == null || rawArgs.length == 0 || rawArgs[0] == null) {
            return rawType;
        }
        return new InternalParameterizedType(rawType, rawArgs);
    }

    public static Type convertToType(JavaType javaType) {
        ArrayList<Type> args = new ArrayList<Type>();
        for (JavaType it : javaType.getBindings().getTypeParameters()) {
            Type type = SerdeUtils.convertToType(it);
            args.add(type);
        }
        return SerdeUtils.constructParametricType(javaType.getRawClass(), args.toArray(new Type[0]));
    }

    static void checkSupportedJacksonVersion() {
        Arrays.asList(com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION, PackageVersion.VERSION).forEach(version -> {
            int major = version.getMajorVersion();
            int minor = version.getMinorVersion();
            if (major != 2 || minor < 10 || minor > 19) {
                LOGGER.warn("Unsupported Jackson version: {}", version);
            }
        });
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public JsonNode parseJson(String json) {
        try {
            return this.jsonMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw ArangoDBException.of(e);
        }
    }

    public String writeJson(JsonNode data) {
        try {
            return this.jsonMapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException e) {
            throw ArangoDBException.of(e);
        }
    }

    public static byte[] extractBytes(JsonParser parser) throws IOException {
        JsonToken t = parser.currentToken();
        if (t.isStructEnd() || t == JsonToken.FIELD_NAME) {
            throw new ArangoDBException("Unexpected token: " + t);
        }
        byte[] data = (byte[])parser.getTokenLocation().getSourceRef();
        int start = (int)parser.getTokenLocation().getByteOffset();
        int end = (int)parser.getCurrentLocation().getByteOffset();
        if (t.isStructStart()) {
            int open = 1;
            while (open > 0) {
                t = parser.nextToken();
                if (t.isStructStart()) {
                    ++open;
                    continue;
                }
                if (!t.isStructEnd()) continue;
                --open;
            }
        }
        parser.finishToken();
        if ("JSON".equals(parser.getCodec().getFactory().getFormatName())) {
            end = (int)parser.getCurrentLocation().getByteOffset();
        }
        return Arrays.copyOfRange(data, start, end);
    }

    public static boolean isManagedClass(Class<?> clazz) {
        return JsonNode.class.isAssignableFrom(clazz) || JsonValue.class.isAssignableFrom(clazz) || RawJson.class.equals(clazz) || RawBytes.class.equals(clazz) || BaseDocument.class.equals(clazz) || BaseEdgeDocument.class.equals(clazz) || SerdeUtils.isEntityClass(clazz);
    }

    private static boolean isEntityClass(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            return false;
        }
        return pkg.getName().startsWith("com.arangodb.entity");
    }

    static {
        LOGGER = LoggerFactory.getLogger(SerdeUtils.class);
    }
}

