/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.ConnectionPool;
import com.arangodb.internal.util.AsyncQueue;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectionPoolImpl
implements ConnectionPool {
    public static final int HTTP1_SLOTS = 1;
    public static final int HTTP1_SLOTS_PIPELINING = 10;
    public static final int HTTP2_SLOTS = 32;
    private final AsyncQueue<Connection> slots = new AsyncQueue();
    private final HostDescription host;
    private final ArangoConfig config;
    private final int maxConnections;
    private final List<Connection> connections;
    private final ConnectionFactory factory;
    private final int maxSlots;
    private volatile String jwt = null;
    private volatile boolean closed = false;

    public ConnectionPoolImpl(HostDescription host, ArangoConfig config, ConnectionFactory factory) {
        this.host = host;
        this.config = config;
        this.maxConnections = config.getMaxConnections();
        this.factory = factory;
        this.connections = new CopyOnWriteArrayList<Connection>();
        switch (config.getProtocol()) {
            case HTTP_JSON: 
            case HTTP_VPACK: {
                this.maxSlots = config.getPipelining() != false ? 10 : 1;
                break;
            }
            default: {
                this.maxSlots = 32;
            }
        }
    }

    @Override
    public Connection createConnection() {
        Connection c = this.factory.create(this.config, this.host, this);
        c.setJwt(this.jwt);
        return c;
    }

    @Override
    public CompletableFuture<Connection> connection() {
        if (this.closed) {
            throw new ArangoDBException("Connection pool already closed!");
        }
        if (this.connections.size() < this.maxConnections) {
            Connection connection = this.createConnection();
            this.connections.add(connection);
            for (int i = 0; i < this.maxSlots; ++i) {
                this.slots.offer(connection);
            }
        }
        return this.slots.poll();
    }

    @Override
    public void release(Connection connection) {
        this.slots.offer(connection);
    }

    @Override
    public void setJwt(String jwt) {
        if (jwt != null) {
            this.jwt = jwt;
            for (Connection connection : this.connections) {
                connection.setJwt(jwt);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (Connection connection : this.connections) {
            connection.close();
        }
    }

    public String toString() {
        return "ConnectionPoolImpl [host=" + this.host + ", maxConnections=" + this.maxConnections + ", connections=" + this.connections.size() + ", factory=" + this.factory.getClass().getSimpleName() + "]";
    }
}

