/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.RequestContext;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RequestContextHolder {
    INSTANCE;

    private static final Logger LOGGER;
    private final ThreadLocal<Boolean> runningWithinCtx = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<RequestContext> ctx = ThreadLocal.withInitial(() -> RequestContext.EMPTY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithCtx(RequestContext requestContext, Supplier<T> fun) {
        T t;
        block6: {
            RequestContext old;
            block5: {
                Objects.requireNonNull(requestContext);
                old = null;
                try {
                    if (this.runningWithinCtx.get().booleanValue()) {
                        old = this.ctx.get();
                    }
                    LOGGER.debug("setting RequestContext: {}", (Object)requestContext);
                    this.ctx.set(requestContext);
                    this.runningWithinCtx.set(true);
                    t = fun.get();
                    if (old != null) break block5;
                }
                catch (Throwable throwable) {
                    if (old == null) {
                        LOGGER.debug("removing RequestContext");
                        this.ctx.remove();
                        this.runningWithinCtx.remove();
                    } else {
                        LOGGER.debug("restore RequestContext: {}", old);
                        this.ctx.set(old);
                    }
                    throw throwable;
                }
                LOGGER.debug("removing RequestContext");
                this.ctx.remove();
                this.runningWithinCtx.remove();
                break block6;
            }
            LOGGER.debug("restore RequestContext: {}", (Object)old);
            this.ctx.set(old);
        }
        return t;
    }

    public RequestContext getCtx() {
        if (!this.runningWithinCtx.get().booleanValue()) {
            throw new IllegalStateException("Not within ctx!");
        }
        RequestContext requestContext = this.ctx.get();
        LOGGER.debug("returning RequestContext: {}", (Object)requestContext);
        return requestContext;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestContextHolder.class);
    }
}

