/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.ArangoGraph;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.model.EdgeCollectionDropOptions;
import com.arangodb.model.EdgeCollectionRemoveOptions;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;

public class ArangoEdgeCollectionImpl
extends InternalArangoEdgeCollection
implements ArangoEdgeCollection {
    private final ArangoGraphImpl graph;

    protected ArangoEdgeCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, graph.db().name(), graph.name(), name);
        this.graph = graph;
    }

    @Override
    public ArangoGraph graph() {
        return this.graph;
    }

    @Override
    @Deprecated
    public void drop() {
        this.drop(new EdgeCollectionDropOptions());
    }

    @Override
    @Deprecated
    public void drop(EdgeCollectionDropOptions options) {
        this.executorSync().execute(this.removeEdgeDefinitionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public void remove() {
        this.remove(new EdgeCollectionRemoveOptions());
    }

    @Override
    public void remove(EdgeCollectionRemoveOptions options) {
        this.executorSync().execute(this.removeEdgeDefinitionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public EdgeEntity insertEdge(Object value) {
        return this.executorSync().execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer());
    }

    @Override
    public EdgeEntity insertEdge(Object value, EdgeCreateOptions options) {
        return this.executorSync().execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer());
    }

    @Override
    public <T> T getEdge(String key, Class<T> type) {
        return this.getEdge(key, type, null);
    }

    @Override
    public <T> T getEdge(String key, Class<T> type, GraphDocumentReadOptions options) {
        try {
            return this.executorSync().execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 304) || ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(e, 412, ArangoErrors.ERROR_ARANGO_CONFLICT)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public EdgeUpdateEntity replaceEdge(String key, Object value) {
        return this.executorSync().execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity replaceEdge(String key, Object value, EdgeReplaceOptions options) {
        return this.executorSync().execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity updateEdge(String key, Object value) {
        return this.executorSync().execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity updateEdge(String key, Object value, EdgeUpdateOptions options) {
        return this.executorSync().execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer());
    }

    @Override
    public void deleteEdge(String key) {
        this.executorSync().execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteEdge(String key, EdgeDeleteOptions options) {
        this.executorSync().execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

