/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch;

import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.internal.serde.InternalDeserializers;
import com.arangodb.internal.serde.InternalSerializers;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class CollectionLink {
    private final String name;
    private Collection<String> analyzers;
    private Boolean includeAllFields;
    private Boolean trackListPositions;
    private StoreValuesType storeValues;
    private Collection<FieldLink> fields;
    private Collection<FieldLink> nested;
    private Boolean inBackground;
    private Boolean cache;

    private CollectionLink(String name) {
        this.name = name;
    }

    @JsonCreator
    public static CollectionLink on(@JsonProperty(value="name") String name) {
        return new CollectionLink(name);
    }

    public CollectionLink analyzers(String ... analyzers) {
        this.analyzers = Arrays.asList(analyzers);
        return this;
    }

    public CollectionLink includeAllFields(Boolean includeAllFields) {
        this.includeAllFields = includeAllFields;
        return this;
    }

    public CollectionLink trackListPositions(Boolean trackListPositions) {
        this.trackListPositions = trackListPositions;
        return this;
    }

    public CollectionLink storeValues(StoreValuesType storeValues) {
        this.storeValues = storeValues;
        return this;
    }

    @JsonDeserialize(using=InternalDeserializers.FieldLinksDeserializer.class)
    public CollectionLink fields(FieldLink ... fields) {
        this.fields = Arrays.asList(fields);
        return this;
    }

    @JsonDeserialize(using=InternalDeserializers.FieldLinksDeserializer.class)
    public CollectionLink nested(FieldLink ... nested) {
        this.nested = Arrays.asList(nested);
        return this;
    }

    public CollectionLink inBackground(Boolean inBackground) {
        this.inBackground = inBackground;
        return this;
    }

    public CollectionLink cache(Boolean cache) {
        this.cache = cache;
        return this;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public Collection<String> getAnalyzers() {
        return this.analyzers;
    }

    public Boolean getIncludeAllFields() {
        return this.includeAllFields;
    }

    public Boolean getTrackListPositions() {
        return this.trackListPositions;
    }

    public StoreValuesType getStoreValues() {
        return this.storeValues;
    }

    @JsonSerialize(using=InternalSerializers.FieldLinksSerializer.class)
    public Collection<FieldLink> getFields() {
        return this.fields;
    }

    @JsonSerialize(using=InternalSerializers.FieldLinksSerializer.class)
    public Collection<FieldLink> getNested() {
        return this.nested;
    }

    public Boolean getInBackground() {
        return this.inBackground;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CollectionLink)) {
            return false;
        }
        CollectionLink that = (CollectionLink)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.analyzers, that.analyzers) && Objects.equals(this.includeAllFields, that.includeAllFields) && Objects.equals(this.trackListPositions, that.trackListPositions) && this.storeValues == that.storeValues && Objects.equals(this.fields, that.fields) && Objects.equals(this.nested, that.nested) && Objects.equals(this.inBackground, that.inBackground) && Objects.equals(this.cache, that.cache);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.analyzers, this.includeAllFields, this.trackListPositions, this.storeValues, this.fields, this.nested, this.inBackground, this.cache});
    }
}

